package com.xforceplus.ultraman.extensions.messagecenter.config;


import com.xforceplus.ultraman.extensions.messagecenter.listener.MessageCenterBulkEventListener;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestTemplate;

public class MessageCenterAutoConfiguration {

    @ConditionalOnMissingBean(GatewayUrlSupplier.class)
    @Bean
    public GatewayUrlSupplier gatewayUrlSupplier(@Value("${xforce.message.gateway.url}") String gateWayUrl){
        return () -> gateWayUrl;
    }

    @ConditionalOnMissingBean(MessageAppIdSupplier.class)
    @Bean
    public MessageAppIdSupplier messageAppIdSupplier(@Value("${xforce.message.appId}") String appId){
        return () -> appId;
    }

    @ConditionalOnBean(value = {MessageAppIdSupplier.class, MessageTokenSupplier.class, GatewayUrlSupplier.class, RestTemplate.class})
    @ConditionalOnProperty(value = "xplat.oqsengine.sdk.export.message.enabled", matchIfMissing = true)
    @Bean
    public MessageCenterBulkEventListener exportEventListener(MessageTokenSupplier tokenSupplier
            , MessageAppIdSupplier appIdSupplier, GatewayUrlSupplier gatewayUrlSupplier
            , @Value("${xplat.oqsengine.sdk.export.message.template.content:#{null}}") String content
            , @Value("${xplat.oqsengine.sdk.export.message.template.title:#{null}}") String title
            , @Value("${xplat.oqsengine.sdk.export.message.context-path:}") String contextPath
            , @Value("${xplat.oqsengine.sdk.export.message.ignore-on-sync:true}") boolean ignoreOnSync
            , RestTemplate restTemplate) {
        return new MessageCenterBulkEventListener(tokenSupplier::getToken
                , appIdSupplier::getStorageAppId, gatewayUrlSupplier::getGatewayUrl
                , content, title, restTemplate, contextPath, ignoreOnSync);
    }
}
