/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.messagecenter.listener;

import com.xforcecloud.noification.model.BaseResponse;
import com.xforcecloud.noification.model.MessageInfo;
import com.xforcecloud.noification.model.Scope;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.listener.ExportEventAwareListener;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.listener.ImportEventAwareListener;
import com.xforceplus.ultraman.sdk.core.event.EntityErrorExported;
import com.xforceplus.ultraman.sdk.core.event.EntityExported;
import com.xforceplus.ultraman.sdk.core.event.EntityImported;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class MessageCenterBulkEventListener
implements ExportEventAwareListener,
ImportEventAwareListener {
    private Supplier<String> tokenSupplier;
    private String senderId;
    private String gatewayUrl;
    private String titleTemplate;
    private String contentTemplate;
    private final RestTemplate restTemplate;
    private String routePattern = "%s/api/%s/message/v1/messages?appId=%s";
    private Logger logger = LoggerFactory.getLogger(MessageCenterBulkEventListener.class);
    private String contextPath = "";
    private final String defaultContentStr = "<a href='$downloadUrl'>$fileName</a>";
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private boolean ignoreOnSync;

    public MessageCenterBulkEventListener(Supplier<String> tokenSupplier, Supplier<String> senderIdSupplier, Supplier<String> gatewayUrl, String contentTemplate, String titleTemplate, RestTemplate restTemplate, String contextPath, boolean ignoreOnSync) {
        this.tokenSupplier = tokenSupplier;
        this.senderId = senderIdSupplier.get();
        this.gatewayUrl = gatewayUrl.get();
        this.restTemplate = restTemplate;
        this.ignoreOnSync = ignoreOnSync;
        this.contentTemplate = contentTemplate != null ? contentTemplate : "<a href='$downloadUrl'>$fileName</a>";
        this.titleTemplate = titleTemplate != null ? titleTemplate : "\u5bfc\u51fa\u4e0b\u8f7d";
        this.contextPath = contextPath;
        Velocity.init();
    }

    @Async
    @EventListener(value={EntityErrorExported.class})
    public void errorListener(EntityErrorExported entityExported) {
        Map context = entityExported.getContext();
        if (context != null) {
            Object tenantIdObj = context.get(ContextKeys.LongKeys.TENANT_ID.name());
            Object userId = context.get(ContextKeys.LongKeys.ID.name());
            if (tenantIdObj != null) {
                Long tenantId = (Long)tenantIdObj;
                MessageInfo messageInfo = new MessageInfo();
                String fileName = entityExported.getFileName();
                String reason = entityExported.getReason();
                messageInfo.setScope(Scope.SINGLE);
                messageInfo.setTitle("\u5bfc\u51fa\u5931\u8d25");
                messageInfo.setContent("\u5bfc\u51fa\u5931\u8d25\uff1a" + fileName + "\uff0c \u539f\u56e0:" + reason);
                messageInfo.setReceiverIds(Arrays.asList((Long)userId));
                messageInfo.setType(Integer.valueOf(0));
                HttpHeaders headers = new HttpHeaders();
                MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
                headers.setContentType(type);
                headers.add("Accept", MediaType.APPLICATION_JSON.toString());
                headers.add("x-app-token", this.tokenSupplier.get());
                String finalAppId = Optional.ofNullable(entityExported.getNotifyContext()).map(ctx -> ctx.get("appId")).map(Objects::toString).orElse(this.senderId);
                HttpEntity messageEntity = new HttpEntity((Object)messageInfo, (MultiValueMap)headers);
                String url = String.format(this.routePattern, this.gatewayUrl, tenantId, finalAppId);
                try {
                    ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)messageEntity, BaseResponse.class, new Object[0]);
                }
                catch (RuntimeException ex) {
                    this.logger.error("{}", (Throwable)ex);
                }
            }
        }
    }

    @Async
    @EventListener(value={EntityExported.class})
    public void messageListener(EntityExported entityExported) {
        if ("sync".equalsIgnoreCase(entityExported.getExportType()) && this.ignoreOnSync) {
            return;
        }
        if ("auto".equals(entityExported.getExportType()) && entityExported.isReturnBeforeDone() && this.ignoreOnSync) {
            return;
        }
        Map context = entityExported.getContext();
        if (context != null) {
            Object tenantIdObj = context.get(ContextKeys.LongKeys.TENANT_ID.name());
            Object userId = context.get(ContextKeys.LongKeys.ID.name());
            if (tenantIdObj != null) {
                Long tenantId = (Long)tenantIdObj;
                MessageInfo messageInfo = new MessageInfo();
                String downloadUrl = entityExported.getDownloadUrl();
                String finalDownloadUrl = this.contextPath + downloadUrl;
                String fileName = entityExported.getFileName();
                messageInfo.setScope(Scope.SINGLE);
                messageInfo.setTitle(this.getRendered(this.titleTemplate, fileName, finalDownloadUrl, entityExported.getEntityClassList(), () -> "\u5bfc\u51fa\u6210\u529f"));
                messageInfo.setContent(this.getRendered(this.contentTemplate, fileName, finalDownloadUrl, entityExported.getEntityClassList(), () -> this.getRendered("<a href='$downloadUrl'>$fileName</a>", finalDownloadUrl, fileName, entityExported.getEntityClassList(), () -> "\u4e0b\u8f7d\u5730\u5740")));
                messageInfo.setReceiverIds(Arrays.asList((Long)userId));
                messageInfo.setType(Integer.valueOf(0));
                HttpHeaders headers = new HttpHeaders();
                MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
                headers.setContentType(type);
                headers.add("Accept", MediaType.APPLICATION_JSON.toString());
                headers.add("x-app-token", this.tokenSupplier.get());
                String finalAppId = Optional.ofNullable(entityExported.getNotifyContext()).map(ctx -> ctx.get("appId")).map(Objects::toString).orElse(this.senderId);
                HttpEntity messageEntity = new HttpEntity((Object)messageInfo, (MultiValueMap)headers);
                String url = String.format(this.routePattern, this.gatewayUrl, tenantId, finalAppId);
                try {
                    ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)messageEntity, BaseResponse.class, new Object[0]);
                }
                catch (RuntimeException ex) {
                    this.logger.error("{}", (Throwable)ex);
                }
            }
        }
    }

    private String getRendered(String template, String fileName, String downloadUrl, List<IEntityClass> entityClassList, Supplier<String> fallbackStr) {
        try {
            VelocityContext context = new VelocityContext();
            context.put("fileName", (Object)fileName);
            context.put("downloadUrl", (Object)downloadUrl);
            context.put("entityCls", entityClassList);
            context.put("ldt", LocalDateTime.class);
            context.put("dtf", DateTimeFormatter.class);
            StringWriter writer = new StringWriter();
            Velocity.evaluate((Context)context, (Writer)writer, (String)"info", (String)template);
            return writer.toString();
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
            return fallbackStr.get();
        }
    }

    public void messageListener(EntityImported entityImported) {
        if ("sync".equalsIgnoreCase(entityImported.getImportType()) && this.ignoreOnSync) {
            return;
        }
        Map context = entityImported.getContext();
        if (context != null) {
            Object tenantIdObj = context.get(ContextKeys.LongKeys.TENANT_ID.name());
            Object userId = context.get(ContextKeys.LongKeys.ID.name());
            Long tenantId = (Long)tenantIdObj;
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setScope(Scope.SINGLE);
            messageInfo.setTitle(entityImported.getCode().concat(" \u5bfc\u5165\u6210\u529f"));
            messageInfo.setContent("\u5b8c\u6210\u4e8e " + LocalDateTime.now().format(this.formatter));
            Object importResultInfo = context.get("importResultInfo");
            if (importResultInfo != null) {
                messageInfo.setContent(messageInfo.getContent() + " " + importResultInfo.toString());
            }
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            headers.add("x-app-token", this.tokenSupplier.get());
            String finalAppId = Optional.ofNullable(entityImported.getNotifyContext()).map(ctx -> ctx.get("appId")).map(Objects::toString).orElse(this.senderId);
            messageInfo.setReceiverIds(Arrays.asList((Long)userId));
            messageInfo.setType(Integer.valueOf(0));
            HttpEntity messageEntity = new HttpEntity((Object)messageInfo, (MultiValueMap)headers);
            String url = String.format(this.routePattern, this.gatewayUrl, tenantId, finalAppId);
            try {
                ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)messageEntity, BaseResponse.class, new Object[0]);
            }
            catch (RuntimeException ex) {
                this.logger.error("{}", (Throwable)ex);
            }
        }
    }
}

