package com.xforceplus.ultraman.extensions.mybatis;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.autoconfigure.SpringBootVFS;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.xforceplus.ultraman.extensions.mybatis.aspect.TransactionalAspect;
import com.xforceplus.ultraman.extensions.mybatis.converter.Long2TimestampHandler;
import com.xforceplus.ultraman.sdk.core.calcite.proxy.ProxyConnection;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.sql.DataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Optional;
import java.util.logging.Logger;

@EnableAspectJAutoProxy
@EnableConfigurationProperties({MybatisPlusProperties.class})
@Configuration
public class SqlSessionFactoryConfiguration {

    public DataSource datasource(Connection connection){
        return new DataSource() {
            @Override
            public Connection getConnection() throws SQLException {
                return new ProxyConnection(connection);
            }

            @Override
            public Connection getConnection(String username, String password) throws SQLException {
                return new ProxyConnection(connection);
            }

            @Override
            public <T> T unwrap(Class<T> iface) throws SQLException {
                return null;
            }

            @Override
            public boolean isWrapperFor(Class<?> iface) throws SQLException {
                return false;
            }

            @Override
            public PrintWriter getLogWriter() throws SQLException {
                return null;
            }

            @Override
            public void setLogWriter(PrintWriter out) throws SQLException {

            }

            @Override
            public void setLoginTimeout(int seconds) throws SQLException {

            }

            @Override
            public int getLoginTimeout() throws SQLException {
                return 0;
            }

            @Override
            public Logger getParentLogger() throws SQLFeatureNotSupportedException {
                return null;
            }
        };
    }

//    @Lazy
//    @Bean
//    public SqlSessionFactory sqlSessionFactory(Connection connection) {
//        TransactionFactory transactionFactory = new JdbcTransactionFactory();
//
//        });
////        org.apache.ibatis.session.Configuration  configuration = new org.apache.ibatis.session.Configuration (environment);
////        configuration.addMappers("com.xforceplus.ultraman.app");
////// Other configuration tweaks
////        SqlSessionFactory sessionFactory = new SqlSessionFactoryBuilder().build(configuration);
////        return sessionFactory;
//
//
//
//    }

    @Bean
    public TransactionalAspect transactionalAspect(DataSource dataSource) {
        return new TransactionalAspect(dataSource);
    }

    @Lazy
    @Bean
    public SqlSessionFactory sqlSessionFactory(Connection connection, MybatisPlusProperties properties) throws Exception {
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        factory.setDataSource(datasource(connection));
        factory.setVfs(SpringBootVFS.class);
        if (properties.getConfigurationProperties() != null) {
            factory.setConfigurationProperties(properties.getConfigurationProperties());
        }

        /**
         * TODO
         */
//        if (!ObjectUtils.isEmpty(interceptors)) {
//            factory.setPlugins(interceptors);
//        }

//        if (databaseIdProvider != null) {
//            factory.setDatabaseIdProvider(databaseIdProvider);
//        }

        if (StringUtils.hasLength(properties.getTypeAliasesPackage())) {
            factory.setTypeAliasesPackage(properties.getTypeAliasesPackage());
        }

        if (properties.getTypeAliasesSuperType() != null) {
            factory.setTypeAliasesSuperType(properties.getTypeAliasesSuperType());
        }

        if (StringUtils.hasLength(properties.getTypeHandlersPackage())) {
            factory.setTypeHandlersPackage(properties.getTypeHandlersPackage());
        }

//        if (!ObjectUtils.isEmpty(typeHandlers)) {
//            factory.setTypeHandlers(typeHandlers);
//        }

        if (!ObjectUtils.isEmpty(properties.resolveMapperLocations())) {
            factory.setMapperLocations(properties.resolveMapperLocations());
        }

        Class<? extends LanguageDriver> defaultLanguageDriver = properties.getDefaultScriptingLanguageDriver();
//        if (!ObjectUtils.isEmpty(languageDrivers)) {
//            factory.setScriptingLanguageDrivers(languageDrivers);
//        }

        Optional.ofNullable(defaultLanguageDriver).ifPresent(factory::setDefaultScriptingLanguageDriver);
        if (StringUtils.hasLength(properties.getTypeEnumsPackage())) {
            factory.setTypeEnumsPackage(properties.getTypeEnumsPackage());
        }

        GlobalConfig globalConfig = properties.getGlobalConfig();
//        if (applicationContext.getBeanNamesForType(MetaObjectHandler.class, false, false).length > 0) {
//            MetaObjectHandler metaObjectHandler = (MetaObjectHandler)applicationContext.getBean(MetaObjectHandler.class);
//            globalConfig.setMetaObjectHandler(metaObjectHandler);
//        }
//        if (applicationContext.getBeanNamesForType(IKeyGenerator.class, false, false).length > 0) {
//            IKeyGenerator keyGenerator = (IKeyGenerator)applicationContext.getBean(IKeyGenerator.class);
//            globalConfig.getDbConfig().setKeyGenerator(keyGenerator);
//        }
//
//        if (applicationContext.getBeanNamesForType(ISqlInjector.class, false, false).length > 0) {
//            ISqlInjector iSqlInjector = (ISqlInjector)applicationContext.getBean(ISqlInjector.class);
//            globalConfig.setSqlInjector(iSqlInjector);
//        }

        factory.setGlobalConfig(globalConfig);
        factory.setTypeHandlers(new Long2TimestampHandler());
        return factory.getObject();
    }
}
