package com.xforceplus.ultraman.extensions.mybatis.aspect;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

import javax.sql.DataSource;

@Aspect
public class TransactionalAspect {

    private DataSource dataSource;
    private TransactionTemplate transactionTemplate;

    public TransactionalAspect(DataSource dataSource) {
        this.dataSource = dataSource;
        this.transactionTemplate = new TransactionTemplate(new DataSourceTransactionManager(dataSource));
    }

    @Pointcut("execution(* com.baomidou.mybatisplus.extension.service.IService.*(..))")
    public void serviceMethods() {}

    @Around("serviceMethods()")
    public Object transactionalAdvice(ProceedingJoinPoint pjp) throws Throwable {
        return transactionTemplate.execute(status -> {
            try {
                Object result = pjp.proceed();
                return result;
            } catch (Throwable t) {
                throw new RuntimeException(t);
            }
        });
    }
}
