package com.xforceplus.ultraman.extensions.mybatis.converter;

import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;

import static com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper.ZONE_ID;

@MappedTypes(value = LocalDateTime.class)
@MappedJdbcTypes(value = {JdbcType.BIGINT})
public class Long2TimestampHandler extends BaseTypeHandler<LocalDateTime> {

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, LocalDateTime parameter, JdbcType jdbcType) throws SQLException {
        Instant instant = parameter.atZone(ZONE_ID).toInstant();
        ps.setLong(i, instant.toEpochMilli());
    }

    @Override
    public LocalDateTime getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Object rs1 = MasterStorageHelper.getRs(rs, columnName, LocalDateTime.class);
        return rs1 == null ? null : (LocalDateTime)rs1;
    }

    @Override
    public LocalDateTime getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Object rs1 = MasterStorageHelper.getRs(rs, columnIndex, LocalDateTime.class);
        return rs1 == null ? null : (LocalDateTime)rs1;
    }

    @Override
    public LocalDateTime getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Object object = cs.getObject(columnIndex);
        Object rs1 = MasterStorageHelper.convert(object, LocalDateTime.class);
        return rs1 == null ? null : (LocalDateTime)rs1;
    }
}