/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.mybatis;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.autoconfigure.SpringBootVFS;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.xforceplus.ultraman.extensions.mybatis.aspect.TransactionalAspect;
import com.xforceplus.ultraman.extensions.mybatis.converter.Long2TimestampHandler;
import com.xforceplus.ultraman.sdk.core.calcite.proxy.ProxyConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Optional;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={MybatisPlusProperties.class})
@Configuration
public class SqlSessionFactoryConfiguration {
    public DataSource datasource(final Connection connection) {
        return new DataSource(){

            @Override
            public Connection getConnection() throws SQLException {
                return new ProxyConnection(connection);
            }

            @Override
            public Connection getConnection(String username, String password) throws SQLException {
                return new ProxyConnection(connection);
            }

            @Override
            public <T> T unwrap(Class<T> iface) throws SQLException {
                return null;
            }

            @Override
            public boolean isWrapperFor(Class<?> iface) throws SQLException {
                return false;
            }

            @Override
            public PrintWriter getLogWriter() throws SQLException {
                return null;
            }

            @Override
            public void setLogWriter(PrintWriter out) throws SQLException {
            }

            @Override
            public void setLoginTimeout(int seconds) throws SQLException {
            }

            @Override
            public int getLoginTimeout() throws SQLException {
                return 0;
            }

            @Override
            public Logger getParentLogger() throws SQLFeatureNotSupportedException {
                return null;
            }
        };
    }

    @Bean
    public TransactionalAspect transactionalAspect(DataSource dataSource) {
        return new TransactionalAspect(dataSource);
    }

    @Lazy
    @Bean
    public SqlSessionFactory sqlSessionFactory(Connection connection, MybatisPlusProperties properties) throws Exception {
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        factory.setDataSource(this.datasource(connection));
        factory.setVfs(SpringBootVFS.class);
        if (properties.getConfigurationProperties() != null) {
            factory.setConfigurationProperties(properties.getConfigurationProperties());
        }
        if (StringUtils.hasLength((String)properties.getTypeAliasesPackage())) {
            factory.setTypeAliasesPackage(properties.getTypeAliasesPackage());
        }
        if (properties.getTypeAliasesSuperType() != null) {
            factory.setTypeAliasesSuperType(properties.getTypeAliasesSuperType());
        }
        if (StringUtils.hasLength((String)properties.getTypeHandlersPackage())) {
            factory.setTypeHandlersPackage(properties.getTypeHandlersPackage());
        }
        if (!ObjectUtils.isEmpty((Object[])properties.resolveMapperLocations())) {
            factory.setMapperLocations(properties.resolveMapperLocations());
        }
        Class defaultLanguageDriver = properties.getDefaultScriptingLanguageDriver();
        Optional.ofNullable(defaultLanguageDriver).ifPresent(arg_0 -> ((MybatisSqlSessionFactoryBean)factory).setDefaultScriptingLanguageDriver(arg_0));
        if (StringUtils.hasLength((String)properties.getTypeEnumsPackage())) {
            factory.setTypeEnumsPackage(properties.getTypeEnumsPackage());
        }
        GlobalConfig globalConfig = properties.getGlobalConfig();
        factory.setGlobalConfig(globalConfig);
        factory.setTypeHandlers(new TypeHandler[]{new Long2TimestampHandler()});
        return factory.getObject();
    }
}

