/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.mybatis.aspect;

import javax.sql.DataSource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Aspect
public class TransactionalAspect {
    private DataSource dataSource;
    private TransactionTemplate transactionTemplate;

    public TransactionalAspect(DataSource dataSource) {
        this.dataSource = dataSource;
        this.transactionTemplate = new TransactionTemplate((PlatformTransactionManager)new DataSourceTransactionManager(dataSource));
    }

    @Pointcut(value="execution(* com.baomidou.mybatisplus.extension.service.IService.*(..))")
    public void serviceMethods() {
    }

    @Around(value="serviceMethods()")
    public Object transactionalAdvice(ProceedingJoinPoint pjp) throws Throwable {
        return this.transactionTemplate.execute(status -> {
            try {
                Object result = pjp.proceed();
                return result;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        });
    }
}

