/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.mybatis.converter;

import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={LocalDateTime.class})
@MappedJdbcTypes(value={JdbcType.BIGINT})
public class Long2TimestampHandler
extends BaseTypeHandler<LocalDateTime> {
    public void setNonNullParameter(PreparedStatement ps, int i, LocalDateTime parameter, JdbcType jdbcType) throws SQLException {
        Instant instant = parameter.atZone(MasterStorageHelper.ZONE_ID).toInstant();
        ps.setLong(i, instant.toEpochMilli());
    }

    public LocalDateTime getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Object rs1 = MasterStorageHelper.getRs((ResultSet)rs, (String)columnName, LocalDateTime.class);
        return rs1 == null ? null : (LocalDateTime)rs1;
    }

    public LocalDateTime getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Object rs1 = MasterStorageHelper.getRs((ResultSet)rs, (int)columnIndex, LocalDateTime.class);
        return rs1 == null ? null : (LocalDateTime)rs1;
    }

    public LocalDateTime getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Object object = cs.getObject(columnIndex);
        Object rs1 = MasterStorageHelper.convert((Object)object, LocalDateTime.class);
        return rs1 == null ? null : (LocalDateTime)rs1;
    }
}

