package com.xforceplus.ultraman.extension.oqsengine.v1;

import com.xforceplus.ultraman.extension.oqsengine.v1.model.StickySession;
import com.xforceplus.ultraman.extension.oqsengine.v1.model.WrappedValueContext;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.sdk.*;
import io.vavr.Tuple2;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public interface EntityGrpcExecutor {

    CompletionStage<OperationResult> prepare(EntityUp in);

    CompletionStage<OperationResult> prepare(String appId, String env);

    CompletionStage<OperationResult> selectOne(EntityUp entityUp, StickySession stickySession,String transId, String profile);

    CompletionStage<OperationResult> removeMulti(List<EntityUp> entityUpList, boolean isForce
            , StickySession stickySession
            , String transId, String profile, String userDisplayName, String userName);

    CompletionStage<OperationResult> remove(EntityUp entityUp, boolean isForce
            , StickySession stickySession
            , String transId, String profile, String userDisplayName, String userName);

    CompletionStage<OperationResult> buildMulti(
            IEntityClass entityClass
            , List<WrappedValueContext> valueContext
            , StickySession stickySession
            , String transId
            , String profile);

    CompletionStage<OperationResult> build(IEntityClass entityClass
            , List<Tuple2<IEntityField, Object>> valueTuple
            , StickySession stickySession
            , String transId
            , String profile, Long id
            , List<Tuple2<IEntityField, Map<String, Object>>> contextField);

    CompletionStage<OperationResult> updateMulti(
            IEntityClass entityClass
            , List<WrappedValueContext> valueContext
            , StickySession stickySession
            , String transId
            , boolean isReplace
            , String profile);

    CompletionStage<OperationResult> updateById(
            IEntityClass entityClass
            , Long id
            , List<Tuple2<IEntityField, Object>> valueTuple
            , List<Tuple2<IEntityField, Map<String, Object>>> contextField
            , StickySession stickySession
            , String transId, String profile
            , boolean isReplace
            , Integer version
    );

    CompletionStage<OperationResult> updateByCondition(
            IEntityClass entityClass
            , SelectByCondition selectByCondition
            , List<Tuple2<IEntityField, Object>> valueTuple
            , StickySession stickySession
            , String transId, String profile, boolean isReplace
    );

    CompletionStage<OperationResult> selectByConditions(SelectByCondition selectByCondition, SelectByTree tree, StickySession stickySession, String transId, String profile, boolean isSimplify);

    CompletionStage<OperationResult> selectByTree(SelectByTree selectByTree, StickySession stickySession, String transId, String profile, boolean isSimplify);

    CompletionStage<ChangelogResponseList> getChangelogList(ChangelogRequest changelogRequest);

    CompletionStage<OperationResult> replay(ReplayRequest replayRequest);

    CompletionStage<ChangelogCountResponse> getChangelogCount(ChangelogCountRequest request);

    CompletionStage<OperationResult> expand(TransRequest trans);

}
