package com.xforceplus.ultraman.extensions.plugin.core;

import com.xforceplus.ultraman.extensions.plugin.dto.ExtensionDefinition;
import com.xforceplus.ultraman.extensions.plugin.dto.ExtensionImplementation;
import com.xforceplus.ultraman.extensions.plugin.dto.cmd.OnEnterCmd;
import io.vavr.Tuple2;
import net.bytebuddy.matcher.ElementMatcher;

import java.util.List;
import java.util.Map;

/**
 * extension engine
 */
public interface ExtensionEngine {

    /**
     * hook related
     * @param targetClass
     * @param adviceClass
     * @param matcher
     */
    void advice(Class targetClass, Class adviceClass, ElementMatcher matcher);

    /**
     * hook related
     * @param targetClass
     */
    void recovery(Class targetClass);
    
    
    Tuple2<ExtensionDefinition, List<ExtensionImplementation>> match(String profile, OnEnterCmd onEnterCmd);

    Object execute(ExtensionDefinition extensionDefinition, List<ExtensionImplementation> extensionImplementations, OnEnterCmd onEnterCmd);
}
