package com.xforceplus.ultraman.extensions.plugin.dto;

import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class ExtensionDefinition {

    private String id;
    
    private String extensionCode;
    
    private String extensionName;

    /**
     * 0: controller 1: service
     */
    private String extensionType;

    /**
     * bean.method
     */
    private String extensionPath;
    
    private String status;

    /**
     * json
     */
    private String extensionInput;

    /**
     * json
     */
    private String extensionOutput;

    /**
     * {
     *         "timeout": "30",
     *         "retry_count": 3,
     *         "is_async": true,
     *         "circuit_breaker": false,
     *         "fallback_method": "defaultFallbackExtendPoint"
     *       }
     */
    private Map<String, Object>  property;
    
    
//    private List<ExtensionImplementation> extensionImpls;
}
