package com.xforceplus.ultraman.extensions.plugin.core.impl;

import com.xforceplus.ultraman.extensions.plugin.core.ExtensionAdvice;
import com.xforceplus.ultraman.extensions.plugin.core.ExtensionEngine;
import com.xforceplus.ultraman.extensions.plugin.core.ExtensionExecutor;
import com.xforceplus.ultraman.extensions.plugin.core.InvokeType;
import com.xforceplus.ultraman.extensions.plugin.dto.ExtensionDefinition;
import com.xforceplus.ultraman.extensions.plugin.dto.ExtensionImplementation;
import com.xforceplus.ultraman.extensions.plugin.dto.cmd.OnEnterCmd;
import com.xforceplus.ultraman.sdk.infra.Eagerness;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import lombok.extern.slf4j.Slf4j;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.matcher.ElementMatcher;

import java.lang.instrument.Instrumentation;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

import static net.bytebuddy.matcher.ElementMatchers.named;

/**
 * default impl
 */
@Slf4j
public class ExtensionEngineImpl implements ExtensionEngine, Refreshable, Eagerness {

    /**
     * useless
     */
    private Instrumentation instrumentation;

    private List<ExtensionExecutor> extensionExecutors;

    private Map<ExtensionDefinition, List<ExtensionImplementation>> implementCache = new ConcurrentHashMap<>();

    public ExtensionEngineImpl(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    @Override
    public void advice(Class targetClass, Class adviceClass, ElementMatcher matcher) {
        DynamicType.Unloaded make = new ByteBuddy()
                .redefine(targetClass)
                .visit(Advice.to(adviceClass).on(matcher))
                .make();

        make.load(getClass().getClassLoader(), ClassReloadingStrategy.fromInstalledAgent());
    }

    @Override
    public void recovery(Class targetClass) {
        new ByteBuddy()
                .redefine(targetClass)
                .make()
                .load(getClass().getClassLoader(), ClassReloadingStrategy.fromInstalledAgent());
    }

    /**
     * TODO
     *
     * @param profile
     * @param onEnterCmd
     * @return
     */
    @Override
    public Tuple2<ExtensionDefinition, List<ExtensionImplementation>> match(String profile, OnEnterCmd onEnterCmd) {
        Optional<Map.Entry<ExtensionDefinition, List<ExtensionImplementation>>> first = implementCache.entrySet().stream().filter(entry -> {
            ExtensionDefinition key = entry.getKey();
            return key.getExtensionPath().equals(onEnterCmd.getDetailedOriginMethod().replace(" ", "#"));
        }).findFirst();

        if (first.isPresent()) {
            Map.Entry<ExtensionDefinition, List<ExtensionImplementation>> extensionDefinitionListEntry = first.get();
            return Tuple.of(extensionDefinitionListEntry.getKey(), extensionDefinitionListEntry.getValue());
        }
        
        return null;
    }

    @Override
    public Object execute(ExtensionDefinition extensionDefinition, List<ExtensionImplementation> extensionImplementations, OnEnterCmd onEnterCmd) {
        Map<String, Object> property = Optional.ofNullable(extensionDefinition.getProperty()).orElseGet(Collections::emptyMap);
        InvokeType invokeTypeE = InvokeType.PICK_FIRST;
        Object invokeType = property.get("invokeType");
        if (invokeType != null) {
            invokeTypeE = InvokeType.valueOf(invokeType.toString());
        }

        if (invokeTypeE == InvokeType.PICK_FIRST) {
            if (extensionImplementations != null && !extensionImplementations.isEmpty()) {
                ExtensionImplementation extensionImplementation = extensionImplementations.get(0);
                String implType = extensionImplementation.getImplType();
                Optional<ExtensionExecutor> executorOptional = extensionExecutors.stream().filter(extensionExecutor -> extensionExecutor.isRequired(implType)).findFirst();
                if (executorOptional.isPresent()) {
                    ExtensionExecutor extensionExecutor = executorOptional.get();
                    return extensionExecutor.executeEnter(extensionDefinition, extensionImplementation, onEnterCmd);
                }
            }
        } else if (invokeType == InvokeType.BROADCAST) {
            //TODO
        } else {
            log.warn("Not Supported InvokeType {}", invokeType);
        }

        return null;
    }

    @Override
    public void onRefresh(Object payload) {
        
    }

    @Override
    public String name() {
        return "ExtensionEngine";
    }

    @Override
    public void onInit(Object payload) {
        //mock one For test
        ExtensionDefinition extensionDefinition = new ExtensionDefinition();
        extensionDefinition.setExtensionCode("mock");
        extensionDefinition.setExtensionName("mock");
        extensionDefinition.setExtensionInput("{}");
        extensionDefinition.setExtensionOutput("{}");
        extensionDefinition.setStatus("1");
        extensionDefinition.setExtensionPath("com.xforceplus.ultraman.plus.demo.service.impl.FooImpl#foo");

        ExtensionImplementation extensionImplementation = new ExtensionImplementation();
        extensionImplementation.setStatus("1");
        extensionImplementation.setExtensionImplCode("mock");
        extensionImplementation.setExtensionImplName("mock");
        extensionImplementation.setExtensionWay("mock");
        extensionImplementation.setImplType("1");
        
        implementCache.compute(extensionDefinition, (k,v) -> {
            if(v == null) {
                v = new ArrayList<>();
            }
            
            v.add(extensionImplementation);
            return v;
        });


        try {
            /**
             * TODO
             */
            this.advice(Class.forName("com.xforceplus.ultraman.plus.demo.service.impl.FooImpl"), ExtensionAdvice.class, named("foo"));
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}
