package com.xforceplus.ultraman.extensions.plugin.config;

import com.xforceplus.ultraman.extensions.plugin.core.AdviceHandlerService;
import com.xforceplus.ultraman.extensions.plugin.core.ExtensionAdvice;
import com.xforceplus.ultraman.extensions.plugin.core.ExtensionEngine;
import com.xforceplus.ultraman.extensions.plugin.core.ExtensionExecutor;
import com.xforceplus.ultraman.extensions.plugin.core.impl.AdviceHandlerServiceImpl;
import com.xforceplus.ultraman.extensions.plugin.core.impl.ExtensionEngineImpl;
import com.xforceplus.ultraman.extensions.plugin.core.impl.MockExtensionExecutor;
import com.xforceplus.ultraman.starter.autoconfigure.UltramanAutoConfiguration;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import java.lang.instrument.Instrumentation;


@AutoConfigureOrder(Ordered.HIGHEST_PRECEDENCE)
@Configuration
@AutoConfigureBefore(UltramanAutoConfiguration.class)
@ConditionalOnProperty("xplat.oqsengine.sdk.exec.extensions.enabled")
public class ExtensionAutoConfiguration {
    
    @Bean
    public ExtensionEngine extensionEngine(ApplicationContext applicationContext) {
        //self attach
        Instrumentation instrumentation = ByteBuddyAgent.install();
        ExtensionEngine extensionEngine = new ExtensionEngineImpl(instrumentation);
        ExtensionAdvice.applicationContext = applicationContext;
        return extensionEngine;
    }
    
//    @ConditionalOnProperty("xplat.oqsengine.sdk.exec.extensions.mock")
    @Bean
    public ExtensionExecutor mockExtensionExecutor() {
        return new MockExtensionExecutor();
    }
    
//    @ConditionalOnMissingBean(AdviceHandlerService.class)
    @Bean
    public AdviceHandlerService adviceHandlerService() {
        return new AdviceHandlerServiceImpl();
    }
}
