package com.xforceplus.ultraman.extensions.plugin.core;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.core.dispatcher.ServiceDispatcher;
import com.xforceplus.ultraman.extensions.plugin.dto.cmd.OnEnterCmd;
import com.xforceplus.ultraman.extensions.plugin.dto.cmd.OnExitCmd;
import com.xforceplus.ultraman.sdk.infra.api.ProfileFetcher;
import lombok.extern.slf4j.Slf4j;
import net.bytebuddy.asm.Advice;
import org.springframework.context.ApplicationContext;

import java.util.Collections;
import java.util.Map;

/**
 * advice 
 */
@Slf4j
public class ExtensionAdvice {

    public static ApplicationContext applicationContext;


    @Advice.OnMethodEnter(suppress = Throwable.class, skipOn = Skip.class)
    public static Object enter(@Advice.This Object thisObject,
                               @Advice.Origin String origin,
                               @Advice.Origin("#t #m") String detailedOrigin,
                               @Advice.AllArguments(readOnly = false) Object[] array) {

        /**
         * wait before set is done
         */
        while(applicationContext == null) {
            try {
                Thread.sleep(10);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        try {
            ServiceDispatcher serviceDispatcher = applicationContext.getBean(ServiceDispatcher.class);
            return serviceDispatcher.querySync(new OnEnterCmd(origin, detailedOrigin, array), AdviceHandlerService.class, "handleEnter");
        } catch (Throwable throwable) {
            log.error("", throwable);
            return null;
        }
    }


    @Advice.OnMethodExit(suppress = Throwable.class, onThrowable = Throwable.class)
    public static void exit(@Advice.Enter Object enterReturn, @Advice.Return(readOnly = true) Object retResult){
        while(applicationContext == null) {
            try {
                Thread.sleep(100);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        try {
            ServiceDispatcher serviceDispatcher = applicationContext.getBean(ServiceDispatcher.class);
            serviceDispatcher.querySync(new OnExitCmd(retResult), AdviceHandlerService.class, "handleExit");
        } catch (Throwable throwable) {
            log.error("", throwable);
        }
    }

    public static void setApplicationContext(ApplicationContext context) {
        applicationContext = context;
    }
}
