package com.xforceplus.ultraman.extensions.plugin.core.impl;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.ultraman.extensions.plugin.core.AdviceHandlerService;
import com.xforceplus.ultraman.extensions.plugin.core.ExtensionEngine;
import com.xforceplus.ultraman.extensions.plugin.dto.ExtensionDefinition;
import com.xforceplus.ultraman.extensions.plugin.dto.ExtensionImplementation;
import com.xforceplus.ultraman.extensions.plugin.dto.cmd.OnEnterCmd;
import com.xforceplus.ultraman.extensions.plugin.dto.cmd.OnExitCmd;
import com.xforceplus.ultraman.sdk.infra.api.ProfileFetcher;
import io.vavr.Tuple2;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;


public class AdviceHandlerServiceImpl implements AdviceHandlerService {

    @Autowired
    private ContextService contextService;

    @Autowired
    private ProfileFetcher profileFetcher;

    @Autowired
    private ExtensionEngine extensionEngine;

    @QueryHandler(isDefault = true)
    @Override
    public Object handleEnter(OnEnterCmd onEnterCmd) {
        String profile = profileFetcher.getProfile(Collections.emptyMap());

        Tuple2<ExtensionDefinition, List<ExtensionImplementation>> match = extensionEngine.match(profile, onEnterCmd);
        if (match != null) {
            return extensionEngine.execute(match._1, match._2, onEnterCmd);
        }

        return null;
    }


    @QueryHandler(isDefault = true)
    @Override
    public Object handleExit(OnExitCmd onExitCmd) {
        return onExitCmd.getRawRet();
    }
}
