/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.plugin.core.impl;

import com.xforceplus.ultraman.extensions.plugin.core.ExtensionAdvice;
import com.xforceplus.ultraman.extensions.plugin.core.ExtensionEngine;
import com.xforceplus.ultraman.extensions.plugin.core.ExtensionExecutor;
import com.xforceplus.ultraman.extensions.plugin.core.InvokeType;
import com.xforceplus.ultraman.extensions.plugin.dto.ExtensionDefinition;
import com.xforceplus.ultraman.extensions.plugin.dto.ExtensionImplementation;
import com.xforceplus.ultraman.extensions.plugin.dto.cmd.OnEnterCmd;
import com.xforceplus.ultraman.sdk.infra.Eagerness;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionEngineImpl
implements ExtensionEngine,
Refreshable,
Eagerness {
    private static final Logger log = LoggerFactory.getLogger(ExtensionEngineImpl.class);
    private Instrumentation instrumentation;
    private List<ExtensionExecutor> extensionExecutors;
    private Map<ExtensionDefinition, List<ExtensionImplementation>> implementCache = new ConcurrentHashMap<ExtensionDefinition, List<ExtensionImplementation>>();

    public ExtensionEngineImpl(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    @Override
    public void advice(Class targetClass, Class adviceClass, ElementMatcher matcher) {
        DynamicType.Unloaded make = new ByteBuddy().redefine(targetClass).visit((AsmVisitorWrapper)Advice.to((Class)adviceClass).on(matcher)).make();
        make.load(this.getClass().getClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
    }

    @Override
    public void recovery(Class targetClass) {
        new ByteBuddy().redefine(targetClass).make().load(this.getClass().getClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
    }

    @Override
    public Tuple2<ExtensionDefinition, List<ExtensionImplementation>> match(String profile, OnEnterCmd onEnterCmd) {
        Optional<Map.Entry> first = this.implementCache.entrySet().stream().filter(entry -> {
            ExtensionDefinition key = (ExtensionDefinition)entry.getKey();
            return key.getExtensionPath().equals(onEnterCmd.getDetailedOriginMethod().replace(" ", "#"));
        }).findFirst();
        if (first.isPresent()) {
            Map.Entry extensionDefinitionListEntry = first.get();
            return Tuple.of(extensionDefinitionListEntry.getKey(), extensionDefinitionListEntry.getValue());
        }
        return null;
    }

    @Override
    public Object execute(ExtensionDefinition extensionDefinition, List<ExtensionImplementation> extensionImplementations, OnEnterCmd onEnterCmd) {
        Map property = Optional.ofNullable(extensionDefinition.getProperty()).orElseGet(Collections::emptyMap);
        InvokeType invokeTypeE = InvokeType.PICK_FIRST;
        Object invokeType = property.get("invokeType");
        if (invokeType != null) {
            invokeTypeE = InvokeType.valueOf(invokeType.toString());
        }
        if (invokeTypeE == InvokeType.PICK_FIRST) {
            if (extensionImplementations != null && !extensionImplementations.isEmpty()) {
                ExtensionImplementation extensionImplementation = extensionImplementations.get(0);
                String implType = extensionImplementation.getImplType();
                Optional<ExtensionExecutor> executorOptional = this.extensionExecutors.stream().filter(extensionExecutor -> extensionExecutor.isRequired(implType)).findFirst();
                if (executorOptional.isPresent()) {
                    ExtensionExecutor extensionExecutor2 = executorOptional.get();
                    return extensionExecutor2.executeEnter(extensionDefinition, extensionImplementation, onEnterCmd);
                }
            }
        } else if (invokeType != InvokeType.BROADCAST) {
            log.warn("Not Supported InvokeType {}", invokeType);
        }
        return null;
    }

    public void onRefresh(Object payload) {
    }

    public String name() {
        return "ExtensionEngine";
    }

    public void onInit(Object payload) {
        ExtensionDefinition extensionDefinition = new ExtensionDefinition();
        extensionDefinition.setExtensionCode("mock");
        extensionDefinition.setExtensionName("mock");
        extensionDefinition.setExtensionInput("{}");
        extensionDefinition.setExtensionOutput("{}");
        extensionDefinition.setStatus("1");
        extensionDefinition.setExtensionPath("com.xforceplus.ultraman.plus.demo.service.impl.FooImpl#foo");
        ExtensionImplementation extensionImplementation = new ExtensionImplementation();
        extensionImplementation.setStatus("1");
        extensionImplementation.setExtensionImplCode("mock");
        extensionImplementation.setExtensionImplName("mock");
        extensionImplementation.setExtensionWay("mock");
        extensionImplementation.setImplType("1");
        this.implementCache.compute(extensionDefinition, (k, v) -> {
            if (v == null) {
                v = new ArrayList<ExtensionImplementation>();
            }
            v.add(extensionImplementation);
            return v;
        });
        try {
            this.advice(Class.forName("com.xforceplus.ultraman.plus.demo.service.impl.FooImpl"), ExtensionAdvice.class, (ElementMatcher)ElementMatchers.named((String)"foo"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

