package com.xforceplus.ultraman.extensions.pipeline.tenant.provider;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.domain.user.view.ExtraInfo;
import com.xforceplus.feign.tenant.user.UserFeignClient;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.starter.service.AuthorizedService;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.tenant.TenantExpressionProvider;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.tenant.provider.extractor.TenantInfoExtractor;
import io.geewit.core.utils.enums.BinaryUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

/**
 * TODO
 * expression provider
 */
public class DefaultTenantExpressionProvider implements TenantExpressionProvider {

    private Logger log = LoggerFactory.getLogger(TenantExpressionProvider.class);

    @Autowired
    private UserFeignClient feignClient;

    @Autowired
    private ContextService contextService;

    private LoadingCache<Long, IAuthorizedUser> userCache;

    private List<TenantInfoExtractor> extractorList;

    public DefaultTenantExpressionProvider(List<TenantInfoExtractor> extractorList, Long cacheTimeout) {
        userCache = Caffeine.newBuilder()
                .maximumSize(1000)
                .expireAfterWrite(cacheTimeout, TimeUnit.SECONDS)
                .build(key -> {
                    return loadingRemote();
                });

        this.extractorList = extractorList;
    }

    @Override
    public Object resolve(IEntityField entityField, String key) {

        Long userAccountId = contextService.get(ContextKeys.LongKeys.ACCOUNT_ID);
        IAuthorizedUser user = userCache.get(userAccountId);
        if (user == null) {
            log.error("Get Remote userinfo error");
            return key;
        } else {
            Optional<TenantInfoExtractor> extractorOptional = extractorList.stream().filter(x -> x.require(key)).findFirst();
            if(extractorOptional.isPresent()) {
                TenantInfoExtractor tenantInfoExtractor = extractorOptional.get();
                Object extract = tenantInfoExtractor.extract(user, entityField, key);
                return extract;
            } else {
                log.warn("Has no extractor for {}", key);
                return key;
            }
        }
    }

    private IAuthorizedUser loadingRemote() {
        try {
            EnumSet<ExtraInfo> extraInfoEnumSet = EnumSet.noneOf(ExtraInfo.class);
            extraInfoEnumSet.add(ExtraInfo.companies);
            extraInfoEnumSet.add(ExtraInfo.currentOrgs);
            int extraInfoDimension = BinaryUtils.toBinary(extraInfoEnumSet);
            /**
             * TODO
             */
            IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
            AuthorizedService authorizedService = new AuthorizedService(feignClient);
            AuthorizedUser extraInfo = authorizedService.userInfo((AuthorizedUser) authorizedUser, extraInfoDimension);
            BeanUtils.copyProperties(extraInfo, authorizedUser);
            return authorizedUser;
        } catch (Exception ex) {
            log.error("{}", ex);
            return null;
        }
    }
}
