/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.pipeline.tenant.provider;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.domain.user.view.ExtraInfo;
import com.xforceplus.feign.tenant.user.UserFeignClient;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.starter.service.AuthorizedService;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.tenant.TenantExpressionProvider;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.tenant.provider.extractor.TenantInfoExtractor;
import io.geewit.core.utils.enums.BinaryUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultTenantExpressionProvider
implements TenantExpressionProvider {
    private Logger log = LoggerFactory.getLogger(TenantExpressionProvider.class);
    @Autowired
    private UserFeignClient feignClient;
    @Autowired
    private ContextService contextService;
    private LoadingCache<Long, IAuthorizedUser> userCache;
    private List<TenantInfoExtractor> extractorList;

    public DefaultTenantExpressionProvider(List<TenantInfoExtractor> extractorList, Long cacheTimeout) {
        this.userCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(cacheTimeout.longValue(), TimeUnit.SECONDS).build(key -> this.loadingRemote());
        this.extractorList = extractorList;
    }

    public Object resolve(IEntityField entityField, String key) {
        Long userAccountId = (Long)this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.ACCOUNT_ID);
        IAuthorizedUser user = (IAuthorizedUser)this.userCache.get((Object)userAccountId);
        if (user == null) {
            this.log.error("Get Remote userinfo error");
            return key;
        }
        Optional<TenantInfoExtractor> extractorOptional = this.extractorList.stream().filter(x -> x.require(key)).findFirst();
        if (extractorOptional.isPresent()) {
            TenantInfoExtractor tenantInfoExtractor = extractorOptional.get();
            Object extract = tenantInfoExtractor.extract(user, entityField, key);
            return extract;
        }
        this.log.warn("Has no extractor for {}", (Object)key);
        return key;
    }

    private IAuthorizedUser loadingRemote() {
        try {
            EnumSet<ExtraInfo> extraInfoEnumSet = EnumSet.noneOf(ExtraInfo.class);
            extraInfoEnumSet.add(ExtraInfo.companies);
            extraInfoEnumSet.add(ExtraInfo.currentOrgs);
            int extraInfoDimension = BinaryUtils.toBinary(extraInfoEnumSet);
            IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
            AuthorizedService authorizedService = new AuthorizedService(this.feignClient);
            AuthorizedUser extraInfo = authorizedService.userInfo((AuthorizedUser)authorizedUser, extraInfoDimension);
            BeanUtils.copyProperties((Object)extraInfo, (Object)authorizedUser);
            return authorizedUser;
        }
        catch (Exception ex) {
            this.log.error("{}", (Throwable)ex);
            return null;
        }
    }
}

