/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions;

import com.xforceplus.ultraman.extensions.pipeline.tenant.provider.DefaultTenantExpressionProvider;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.QuerySideFieldOperationHandler;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.tenant.TenantExpressionProvider;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.tenant.TenantRelatedExpressionFieldOperationHandler;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.tenant.provider.extractor.OrgCodeExtractor;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.tenant.provider.extractor.OrgIdExtractor;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.tenant.provider.extractor.TenantInfoExtractor;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(name={"com.xforceplus.tenant.security.starter.service.AuthorizedService", "com.xforceplus.feign.tenant.user.UserFeignClient"})
@Configuration
public class TenantProviderConfiguration {
    @Bean
    public TenantExpressionProvider tenantProvider(List<TenantInfoExtractor> extractorList) {
        return new DefaultTenantExpressionProvider(extractorList, 1000L);
    }

    @Bean
    public QuerySideFieldOperationHandler tenantRelatedExpressionFieldOperationHandler(TenantExpressionProvider tenantExpressionProvider) {
        return new TenantRelatedExpressionFieldOperationHandler(tenantExpressionProvider);
    }

    @Bean
    public TenantInfoExtractor orgCode() {
        return new OrgCodeExtractor();
    }

    @Bean
    public TenantInfoExtractor orgId() {
        return new OrgIdExtractor();
    }
}

