/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.admin.om.controller;

import com.xforceplus.ultraman.extension.changelog.history.ChangelogFacade;
import com.xforceplus.ultraman.extension.changelog.history.domain.ChangelogEntity;
import com.xforceplus.ultraman.extension.changelog.history.domain.KeyBasedQuery;
import com.xforceplus.ultraman.metadata.domain.vo.Page;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Conditions;
import com.xforceplus.ultraman.metadata.domain.vo.dto.FieldCondition;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Response;
import com.xforceplus.ultraman.metadata.domain.vo.dto.RowItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.SummaryItem;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(value={"/data-om/changelog"})
public class ChangelogController {
    @Autowired
    private ChangelogFacade changelogFacade;

    @PostMapping(value={"/query"})
    public ResponseEntity<Response<RowItem<ChangelogEntity>>> queryDeleted(@RequestBody ConditionQueryRequest request) {
        try {
            KeyBasedQuery keyBasedQuery = this.toKey(request);
            Page historyByEntityClass = this.changelogFacade.findChangelogByEntityClass(keyBasedQuery);
            return ResponseEntity.ok(this.toResponse((Page<ChangelogEntity>)historyByEntityClass));
        }
        catch (Throwable throwable) {
            Response response = new Response();
            response.setCode("0");
            response.setMessage(throwable.getMessage());
            response.setResult(Collections.emptyList());
            return ResponseEntity.status((int)500).body((Object)response);
        }
    }

    private KeyBasedQuery toKey(ConditionQueryRequest request) {
        KeyBasedQuery keyBasedQuery = new KeyBasedQuery();
        Conditions conditions = request.getConditions();
        if (conditions != null) {
            List fields = conditions.getFields();
            Optional<FieldCondition> boId = fields.stream().filter(x -> x.getCode().equalsIgnoreCase("bo_id")).findFirst();
            boId.ifPresent(fieldCondition -> keyBasedQuery.setEntityClassId(Long.parseLong((String)fieldCondition.getValue().get(0))));
            Optional<FieldCondition> key1 = fields.stream().filter(x -> x.getCode().equalsIgnoreCase("key1")).findFirst();
            key1.ifPresent(con -> keyBasedQuery.setKeys1((String)con.getValue().get(0)));
            Optional<FieldCondition> id = fields.stream().filter(x -> x.getCode().equalsIgnoreCase("id")).findFirst();
            id.ifPresent(con -> keyBasedQuery.setId(Long.parseLong((String)con.getValue().get(0))));
        }
        Integer pageNo = request.getPageNo();
        Integer pageSize = request.getPageSize();
        keyBasedQuery.setPage(pageNo.intValue());
        keyBasedQuery.setSize(pageSize.intValue());
        if (keyBasedQuery.getEntityClassId() == 0L) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u5bf9\u8c61");
        }
        return keyBasedQuery;
    }

    private Response<RowItem<ChangelogEntity>> toResponse(Page<ChangelogEntity> histories) {
        Response response = new Response();
        response.setCode("1");
        RowItem rowItem = new RowItem();
        rowItem.setRows(histories.getRows());
        SummaryItem summaryItem = new SummaryItem();
        summaryItem.setTotal(Integer.valueOf((int)histories.getSummary().getTotal()));
        rowItem.setSummary(summaryItem);
        response.setResult((Object)rowItem);
        return response;
    }
}

