/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.admin.om.controller;

import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.extensions.admin.om.audit.EnableOmAuditLog;
import com.xforceplus.ultraman.extensions.admin.om.util.OmTenantUtil;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Response;
import com.xforceplus.ultraman.metadata.domain.vo.dto.RowItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.SummaryItem;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleCreateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleDeleteCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleQueryCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleUpdateCmd;
import com.xforceplus.ultraman.sdk.core.service.EntityHandlerService;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.errors.EncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@RequestMapping(value={"api/0/${xplat.oqsengine.sdk.auth.appcode:global}/data-om", "/data-om"})
public class QOmBoApiController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="entityServiceHandler")
    private EntityHandlerService defaultEntityServiceHandler;
    @Autowired
    private OmTenantUtil omTenantUtil;
    @Autowired
    private ContextService contextService;
    private static final String MISSING_ENTITIES = "\u67e5\u8be2\u5bf9\u8c61\u4e0d\u5b58\u5728";

    @GetMapping(value={"/bos/{boId}/entities/{id}"})
    @ResponseBody
    public ResponseEntity<Response<Map<String, Object>>> singleQuery(@PathVariable String boId, @PathVariable String id, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="pageCode") String pageCode, @RequestParam(value="profile", required=false) String profileInput) {
        if (!StringUtils.isEmpty((CharSequence)profileInput)) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)profileInput);
        }
        Either result = this.defaultEntityServiceHandler.singleQuery(new SingleQueryCmd(boId, id, version));
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response rep = new Response();
            rep.setCode("1");
            rep.setMessage("\u83b7\u53d6\u6210\u529f");
            rep.setResult(x);
            return ResponseEntity.ok((Object)rep);
        }).getOrElseGet(str -> {
            Response rep = new Response();
            rep.setCode("-1");
            rep.setMessage("\u64cd\u4f5c\u5931\u8d25:".concat((String)str));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)rep);
        });
    }

    @EnableOmAuditLog
    @DeleteMapping(value={"/bos/{boId}/entities/{id}"})
    @ResponseBody
    public ResponseEntity<Response<String>> singleDelete(@PathVariable String boId, @PathVariable String id, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="pageCode") String pageCod, @RequestParam(value="profile", required=false) String profileInput) {
        if (!StringUtils.isEmpty((CharSequence)profileInput)) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)profileInput);
        }
        Either result = this.defaultEntityServiceHandler.singleDelete(new SingleDeleteCmd(boId, id, version));
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response rep = new Response();
            rep.setCode("1");
            rep.setResult((Object)String.valueOf(x));
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok((Object)rep);
        }).getOrElseGet(str -> {
            Response rep = new Response();
            rep.setCode("-1");
            rep.setMessage("\u64cd\u4f5c\u5931\u8d25:".concat((String)str));
            rep.setResult(str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)rep);
        });
    }

    @EnableOmAuditLog
    @PostMapping(value={"/bos/{boId}/entities"})
    @ResponseBody
    public ResponseEntity<Response<String>> singleCreate(@PathVariable String boId, @RequestParam(required=false, value="v") String version, @RequestBody Map<String, Object> body, @RequestParam(value="profile", required=false) String profileInput) {
        if (!StringUtils.isEmpty((CharSequence)profileInput)) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)profileInput);
        }
        Either result = this.defaultEntityServiceHandler.singleCreate(new SingleCreateCmd(boId, body, version));
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response rep = new Response();
            rep.setCode("1");
            rep.setResult((Object)String.valueOf(x));
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok((Object)rep);
        }).getOrElseGet(str -> {
            Response rep = new Response();
            rep.setCode("-1");
            rep.setMessage("\u64cd\u4f5c\u5931\u8d25:".concat((String)str));
            rep.setResult(str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)rep);
        });
    }

    @EnableOmAuditLog
    @PutMapping(value={"/bos/{boId}/entities/{id}"})
    @ResponseBody
    public ResponseEntity<Response<String>> singleModify(@PathVariable String boId, @PathVariable Long id, @RequestParam(required=false, value="v") String version, @RequestBody Map<String, Object> body, @RequestParam(value="profile", required=false) String profileInput) {
        if (!StringUtils.isEmpty((CharSequence)profileInput)) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)profileInput);
        }
        Either result = this.defaultEntityServiceHandler.singleUpdate(new SingleUpdateCmd(boId, id, body, version));
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response rep = new Response();
            rep.setCode("1");
            rep.setResult((Object)String.valueOf(x));
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok((Object)rep);
        }).getOrElseGet(str -> {
            Response rep = new Response();
            rep.setCode("-1");
            rep.setMessage("\u64cd\u4f5c\u5931\u8d25:".concat((String)str));
            rep.setResult(str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)rep);
        });
    }

    @PostMapping(value={"/bos/{boId}/entities/query"})
    @ResponseBody
    public ResponseEntity<Response<RowItem<Map<String, Object>>>> conditionQuery(@PathVariable String boId, @RequestParam(required=false, value="v") String version, @RequestBody ConditionQueryRequest condition, @RequestParam(required=false, value="pageCode") String pageCode, @RequestParam(value="profile", required=false) String profileInput) {
        if (!StringUtils.isEmpty((CharSequence)profileInput)) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)profileInput);
        }
        this.omTenantUtil.buildTenantCondition(condition);
        Integer pageNo = condition.getPageNo() == null ? 1 : condition.getPageNo();
        Integer pageSize = condition.getPageSize() == null ? 20 : condition.getPageSize();
        if ((pageNo - 1) * pageSize >= 10000) {
            return this.extractRepList(Either.left((Object)"\u60a8\u67e5\u8be2\u7684\u6570\u636e\u8d85\u8fc7\u4e861W\u6761\uff0c\u8bf7\u901a\u8fc7\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\uff08\u5982\u65f6\u95f4\u7b49\uff09\u6765\u7f29\u5c0f\u6570\u636e\u8303\u56f4"));
        }
        Either result = this.defaultEntityServiceHandler.conditionSearch(new ConditionSearchCmd(boId, condition, version, pageCode));
        return this.extractRepList(Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")));
    }

    private <T> ResponseEntity<Response<RowItem<T>>> extractRepList(Either<String, Tuple2<Integer, List<T>>> result) {
        Response rep = new Response();
        if (result.isRight()) {
            Object errors;
            rep.setCode("1");
            Tuple2 tuple = (Tuple2)result.get();
            RowItem rowItem = new RowItem();
            rowItem.setSummary(new SummaryItem((Integer)tuple._1()));
            rowItem.setRows((List)tuple._2());
            rep.setResult((Object)rowItem);
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            Object o = this.contextService.getAll().get("invocation");
            HttpHeaders httpHeaders = new HttpHeaders();
            if (o != null) {
                httpHeaders.add("invocation", o.toString());
            }
            if ((errors = this.contextService.getAll().get("errors")) instanceof List) {
                String errMsg = ((List)errors).stream().map(Object::toString).distinct().collect(Collectors.joining(","));
                try {
                    httpHeaders.add("err", ESAPI.encoder().encodeForURL(errMsg));
                }
                catch (EncodingException encodingException) {
                    // empty catch block
                }
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders)).body((Object)rep);
        }
        rep.setCode("-1");
        rep.setMessage("\u64cd\u4f5c\u5931\u8d25:".concat((String)result.getLeft()));
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)rep);
    }
}

