/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.admin.om.controller;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.extensions.admin.om.audit.EnableOmAuditLog;
import com.xforceplus.ultraman.extensions.admin.om.controller.QOmBoApiController;
import com.xforceplus.ultraman.extensions.admin.om.enums.QErrorCode;
import com.xforceplus.ultraman.extensions.admin.om.vo.QAppInfo;
import com.xforceplus.ultraman.extensions.admin.om.vo.QBoApiVo;
import com.xforceplus.ultraman.extensions.admin.om.vo.QBoFieldVo;
import com.xforceplus.ultraman.extensions.admin.om.vo.QBoInfo;
import com.xforceplus.ultraman.extensions.admin.om.vo.QBoResult;
import com.xforceplus.ultraman.extensions.admin.om.vo.QConditionModifyPayload;
import com.xforceplus.ultraman.extensions.admin.om.vo.QDataResponse;
import com.xforceplus.ultraman.extensions.admin.om.vo.QDeletePayload;
import com.xforceplus.ultraman.extensions.admin.om.vo.QModifyPayload;
import com.xforceplus.ultraman.extensions.admin.om.vo.QPageInfo;
import com.xforceplus.ultraman.extensions.admin.om.vo.QPageVo;
import com.xforceplus.ultraman.metadata.domain.vo.dto.FieldItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Response;
import com.xforceplus.ultraman.metadata.domain.vo.dto.RowItem;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.core.cmd.BatchDeleteCmd;
import com.xforceplus.ultraman.sdk.core.cmd.BatchUpdateCmd;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.service.EntityHandlerService;
import io.vavr.control.Either;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@RequestMapping(value={"api/0/${xplat.oqsengine.sdk.auth.appcode:global}/data-om", "/data-om"})
public class QOmDataController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String AUDIT_BO_CODE = "oqsengineSdkOmAuditLog";
    private final List<String> SYSTEM_BOS = Arrays.asList("oqsengineSdkOmAuditLog");
    @Autowired
    private ContextService contextService;
    @Autowired
    private QOmBoApiController qOmBoApiController;
    @Autowired
    private EntityClassEngine engine;
    @Autowired
    private ProfileFetcher fetcher;
    @Autowired
    private DynamicConfig dynamicConfig;
    @Autowired
    @Qualifier(value="entityServiceHandler")
    private EntityHandlerService defaultEntityServiceHandler;
    @Value(value="${xplat.meta.oqsengine.data.om.modify-limit:50000}")
    private Integer modifyLimit;
    private List<QBoApiVo> defaultBoApis = Lists.newArrayList((Object[])new QBoApiVo[]{new QBoApiVo(null, "\u67e5\u8be2", "query", "/data-om/bos/%d/entities/query", "post"), new QBoApiVo(null, "\u5355\u4e2a\u67e5\u8be2", "queryOne", "/data-om/bos/%d/entities/{id}", "get"), new QBoApiVo(null, "\u521b\u5efa", "create", "/data-om/bos/%d/entities", "post"), new QBoApiVo(null, "\u4fee\u6539", "update", "/data-om/bos/%d/entities/{id}", "put"), new QBoApiVo(null, "\u5220\u9664", "delete", "/data-om/bos/%d/entities/{id}", "delete"), new QBoApiVo(null, "\u5bfc\u5165", "import", "/data-om/bos/%d/entities/import", "post"), new QBoApiVo(null, "\u5bfc\u51fa", "export", "/data-om/bos/%d/entities/export", "post"), new QBoApiVo(null, "\u5bfc\u5165\u6a21\u677f", "importTemplate", "/data-om/bos/%d/entities/import/template", "get")});

    @EnableOmAuditLog
    @DeleteMapping(value={"/bos/{boId}/entities"})
    public ResponseEntity<Response<String>> batchDelete(@PathVariable String boId, @RequestBody QDeletePayload payload, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="profile") String profile) {
        this.logger.info("batch delete payload: " + JSON.toJSONString((Object)payload));
        if (!StringUtils.isEmpty((CharSequence)profile)) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)profile);
        }
        Either result = this.defaultEntityServiceHandler.batchDelete(new BatchDeleteCmd(boId, payload.getIncludes(), version));
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response rep = new Response();
            rep.setCode("1");
            rep.setResult((Object)String.valueOf(x));
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok((Object)rep);
        }).getOrElseGet(str -> {
            Response rep = new Response();
            rep.setCode("-1");
            rep.setMessage("\u64cd\u4f5c\u5931\u8d25:".concat((String)str));
            rep.setResult(str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)rep);
        });
    }

    @EnableOmAuditLog
    @PutMapping(value={"/bos/{boId}/entities"})
    public ResponseEntity<Response<String>> batchModify(@PathVariable String boId, @RequestParam(required=false, value="v") String version, @RequestBody QModifyPayload modifyPayload, @RequestParam(required=false, value="profile") String profile) {
        if (!StringUtils.isEmpty((CharSequence)profile)) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)profile);
        }
        this.logger.info("batch modify payload: " + JSON.toJSONString((Object)modifyPayload));
        Map<String, Object> body = modifyPayload.getBody();
        List<String> includes = modifyPayload.getIncludes();
        List bodies = includes.stream().map(x -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.putAll(body);
            map.put("id", (String)x);
            return map;
        }).collect(Collectors.toList());
        Either integers = this.defaultEntityServiceHandler.batchUpdate(new BatchUpdateCmd(boId, bodies, version));
        return (ResponseEntity)Optional.ofNullable(integers).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response rep = new Response();
            rep.setCode("1");
            rep.setResult((Object)String.valueOf(x));
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok((Object)rep);
        }).getOrElseGet(str -> {
            Response rep = new Response();
            rep.setCode("-1");
            rep.setMessage("\u64cd\u4f5c\u5931\u8d25:".concat((String)str));
            rep.setResult(str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)rep);
        });
    }

    @EnableOmAuditLog
    @PutMapping(value={"/bos/{boId}/entities/all"})
    public ResponseEntity<Response<String>> batchModifyAll(@PathVariable String boId, @RequestParam(required=false, value="v") String version, @RequestBody QConditionModifyPayload modifyPayload, @RequestParam(required=false, value="pageCode") String pageCode, @RequestParam(required=false, value="profile") String profile) {
        if (!StringUtils.isEmpty((CharSequence)profile)) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)profile);
        }
        if (null == modifyPayload.getCondition() || null == modifyPayload.getCondition().getConditions() || null == modifyPayload.getCondition().getConditions().getFields() || modifyPayload.getCondition().getConditions().getFields().isEmpty()) {
            return new ResponseEntity((Object)Response.Error((String)"\u8bf7\u6dfb\u52a0\u7b5b\u9009\u6761\u4ef6"), null, HttpStatus.ACCEPTED);
        }
        modifyPayload.getCondition().setPageNo(Integer.valueOf(1));
        modifyPayload.getCondition().setPageSize(Integer.valueOf(10000));
        ResponseEntity<Response<RowItem<Map<String, Object>>>> result = this.qOmBoApiController.conditionQuery(boId, version, modifyPayload.getCondition(), pageCode, profile);
        List rows = ((RowItem)((Response)result.getBody()).getResult()).getRows();
        if (rows.size() > this.modifyLimit) {
            return new ResponseEntity((Object)Response.Error((String)("\u7b5b\u9009\u7ed3\u679c\u8d85\u8fc7\u4fee\u6539\u4e0a\u9650" + this.modifyLimit + "\u6761")), HttpStatus.ACCEPTED);
        }
        this.logger.info("batch modify all datas: " + JSON.toJSONString((Object)rows));
        Map<String, Object> body = modifyPayload.getBody();
        List bodies = rows.stream().map(x -> {
            HashMap map = new HashMap();
            map.putAll(body);
            map.put("id", x.get("id"));
            return map;
        }).collect(Collectors.toList());
        Either integers = this.defaultEntityServiceHandler.batchUpdate(new BatchUpdateCmd(boId, bodies, version));
        return (ResponseEntity)Optional.ofNullable(integers).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response rep = new Response();
            rep.setCode("1");
            rep.setResult((Object)String.valueOf(x));
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok((Object)rep);
        }).getOrElseGet(str -> {
            Response rep = new Response();
            rep.setCode("-1");
            rep.setMessage("\u64cd\u4f5c\u5931\u8d25:".concat((String)str));
            rep.setResult(str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)rep);
        });
    }

    @GetMapping(value={"/bos"})
    public QDataResponse<QPageInfo> queryBos(@RequestParam(required=false, value="profile") String profileInput, QPageVo queryBoVo) {
        if (!StringUtils.isEmpty((CharSequence)profileInput)) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)profileInput);
        }
        String profile = this.fetcher.getProfile(Collections.emptyMap());
        List entityClasss = this.engine.findAllEntities(profile);
        if (!StringUtils.isEmpty((CharSequence)queryBoVo.getText())) {
            entityClasss = entityClasss.stream().filter(entityClass -> entityClass.name().contains(queryBoVo.getText()) || entityClass.code().contains(queryBoVo.getText())).collect(Collectors.toList());
        }
        List qBoInfos = entityClasss.stream().filter(entityClass -> !this.SYSTEM_BOS.contains(entityClass.code())).map(entityClass -> {
            QBoInfo qBoInfo = new QBoInfo();
            qBoInfo.setId(entityClass.id());
            qBoInfo.setCode(entityClass.code());
            qBoInfo.setName(entityClass.name());
            String parentBoNames = "";
            IEntityClass extendEntityClass = null;
            if (entityClass.extendEntityClass() != null) {
                parentBoNames = entityClass.extendEntityClass().code();
                extendEntityClass = this.engine.loadByCode(entityClass.extendEntityClass().code(), profile).orElse(null);
            }
            while (extendEntityClass != null && extendEntityClass.extendEntityClass() != null) {
                parentBoNames = parentBoNames + "/" + extendEntityClass.extendEntityClass().code();
                extendEntityClass = this.engine.loadByCode(extendEntityClass.extendEntityClass().code(), "").orElse(null);
            }
            qBoInfo.setParentBoName(parentBoNames);
            String relationBoNames = "";
            if (entityClass.entityClasses() != null) {
                relationBoNames = entityClass.entityClasses().stream().map(IEntityClass::code).distinct().sorted().collect(Collectors.joining("/"));
            }
            String pRelationBoNames = "";
            if (entityClass.extendEntityClass() != null && entityClass.extendEntityClass().entityClasses() != null) {
                pRelationBoNames = entityClass.extendEntityClass().entityClasses().stream().map(IEntityClass::code).distinct().sorted().collect(Collectors.joining("/"));
            }
            qBoInfo.setRelationBoNames(this.getRelationBoNames(relationBoNames, pRelationBoNames));
            return qBoInfo;
        }).collect(Collectors.toList());
        int offset = (queryBoVo.getCurrent() - 1) * queryBoVo.getSize();
        qBoInfos = qBoInfos.size() <= offset ? Lists.newArrayList() : (qBoInfos.size() > offset + queryBoVo.getSize() ? qBoInfos.subList(offset, offset + queryBoVo.getSize()) : qBoInfos.subList(offset, qBoInfos.size()));
        QDataResponse<QPageInfo> response = new QDataResponse<QPageInfo>();
        response.setCode(QErrorCode.SUCCESS.getCode());
        QPageInfo pageInfo = new QPageInfo();
        pageInfo.setRows(qBoInfos);
        pageInfo.setTotal(entityClasss.size());
        response.setResult(pageInfo);
        return response;
    }

    @GetMapping(value={"/bos/{boCode}"})
    public QDataResponse getBo(@PathVariable String boCode, @RequestParam(value="profile", required=false) String profileInput) {
        String profile;
        Optional optional;
        if (!StringUtils.isEmpty((CharSequence)profileInput)) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)profileInput);
        }
        if ((optional = this.engine.loadByCode(boCode, profile = this.fetcher.getProfile(Collections.emptyMap()))).isPresent()) {
            IEntityClass entityClass = (IEntityClass)optional.get();
            QBoResult boResult = new QBoResult();
            List<QBoApiVo> boApis = this.buildDefaultBoApis(entityClass.id());
            HashMap apis = Maps.newHashMap();
            boApis.stream().forEach(bApi -> {
                HashMap mApi = Maps.newHashMap();
                mApi.put("url", bApi.getUrl());
                mApi.put("method", bApi.getMethod());
                apis.put(bApi.getCode(), mApi);
            });
            boResult.setApi(apis);
            EntityClassGroup describe = this.engine.describe(entityClass, this.fetcher.getProfile(Collections.emptyMap()));
            List<QBoFieldVo> collect = describe.getAllFields().stream().filter(field -> this.filterFields((IEntityField)field)).map(this::convertField).collect(Collectors.toList());
            boResult.setFields(collect);
            return QDataResponse.ok(boResult);
        }
        return QDataResponse.fail("");
    }

    @GetMapping(value={"/appinfo"})
    public QDataResponse<QAppInfo> getAppInfo(@RequestParam(value="profile", required=false) String profileInput) {
        if (!StringUtils.isEmpty((CharSequence)profileInput)) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)profileInput);
        }
        String profile = this.fetcher.getProfile(Collections.emptyMap());
        QAppInfo qAppInfo = new QAppInfo();
        Map indexRouting = this.dynamicConfig.getIndexRouting();
        Map masterRouting = this.dynamicConfig.getMasterRouting();
        HashSet<String> profiles = new HashSet<String>();
        profiles.addAll(indexRouting.keySet());
        profiles.addAll(masterRouting.keySet());
        String appCode = this.engine.appCode();
        qAppInfo.setAppCode(appCode);
        qAppInfo.setProfiles(profiles);
        Optional auditBoEntityClassOptl = this.engine.loadByCode("oqsengineSdkOmAuditLog", profile);
        if (auditBoEntityClassOptl.isPresent()) {
            qAppInfo.setAuditBoId(((IEntityClass)auditBoEntityClassOptl.get()).id());
        } else {
            qAppInfo.setAuditBoId(null);
        }
        return QDataResponse.ok(qAppInfo);
    }

    List<QBoApiVo> buildDefaultBoApis(Long boId) {
        return this.defaultBoApis == null ? Lists.newArrayList() : this.defaultBoApis.stream().map(api -> new QBoApiVo(boId, api.getName(), api.getCode(), String.format(api.getUrl(), boId), api.getMethod())).collect(Collectors.toList());
    }

    String convertType(String type) {
        if ("datetime".equals(type = StringUtils.lowerCase((String)type))) {
            type = "timestamp";
        } else if ("long".equals(type)) {
            type = "serialNo";
        }
        return type;
    }

    QBoFieldVo convertField(IEntityField field) {
        QBoFieldVo boFieldVo = new QBoFieldVo();
        boFieldVo.setCode(field.name());
        if (StringUtils.isEmpty((CharSequence)field.cnName())) {
            boFieldVo.setName(field.name());
        } else {
            boFieldVo.setName(field.cnName());
        }
        boFieldVo.setType(this.convertType(field.type().getType()));
        boFieldVo.setDefaultValue(field.defaultValue());
        boFieldVo.setEnumId(field.dictId());
        boFieldVo.setEnumCode(field.dictId());
        boFieldVo.setEditable(true);
        boFieldVo.setSearchable(field.config().isSearchable());
        boFieldVo.setRequired(field.config().isRequired());
        boFieldVo.setUnique(field.config().isIdentifie());
        boFieldVo.setValidateRule(field.config().getValidateRegexString());
        boFieldVo.setDecimalPoint(field.config().getPrecision());
        boFieldVo.setMaxLength(field.config().getMax());
        return boFieldVo;
    }

    QBoFieldVo convertField2(FieldItem field) {
        QBoFieldVo boFieldVo = new QBoFieldVo();
        boFieldVo.setCode(field.getCode());
        boFieldVo.setName(field.getName());
        boFieldVo.setType(field.getType());
        boFieldVo.setDefaultValue(field.getDefaultValue());
        boFieldVo.setEnumId(field.getDictId());
        boFieldVo.setEnumCode(field.getEnumCode());
        boFieldVo.setEditable(true);
        boFieldVo.setSearchable(true);
        boFieldVo.setRequired("1".equals(field.getRequired()));
        boFieldVo.setUnique(false);
        boFieldVo.setValidateRule(null);
        boFieldVo.setDecimalPoint(StringUtils.isEmpty((CharSequence)field.getPrecision()) ? 0 : Integer.valueOf(field.getPrecision()));
        boFieldVo.setMaxLength(StringUtils.isEmpty((CharSequence)field.getMaxLength()) ? 0L : Long.valueOf(field.getMaxLength()));
        return boFieldVo;
    }

    String getRelationBoNames(String child, String parent) {
        if (!StringUtils.isEmpty((CharSequence)child) && !StringUtils.isEmpty((CharSequence)parent)) {
            return String.format("%s, \u7236\uff1a%s", child, parent);
        }
        if (!StringUtils.isEmpty((CharSequence)child)) {
            return child;
        }
        if (!StringUtils.isEmpty((CharSequence)parent)) {
            return String.format("\u7236\uff1a%s", parent);
        }
        return "";
    }

    boolean filterFields(IEntityField field) {
        return !StringUtils.isEmpty((CharSequence)field.name());
    }
}

