/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.admin.om.util;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.domain.vo.dto.AppItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.domain.vo.dto.FieldCondition;
import com.xforceplus.ultraman.metadata.repository.MetadataRepository;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class OmTenantUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String ULTRAMAN_ADMIN_ROLE = "ultramanAdmin";
    private final String APP_ADMIN_ROLE = "appAdmin";
    private final String ADMIN_ROLE_SUFFIX = "Admin";
    private final String DEVOPS_ROLE_SUFFIX = "DevOps";
    @Value(value="${xplat.meta.oqsengine.data.om.tenant.enabled:false}")
    private Boolean tenantEnabled;
    @Autowired
    private ContextService contextService;
    @Autowired
    private MetadataRepository metadataRepository;

    public boolean skipTenant() {
        String appAdminRoleCode = this.getAppRoleCode("Admin");
        String appDevOpsRoleCode = this.getAppRoleCode("DevOps");
        Collection roleCodes = (Collection)this.contextService.get((ContextService.ContextKey)ContextKeys.CollectionKeys.ROLE_CODES);
        return roleCodes != null && (roleCodes.contains("ultramanAdmin") || roleCodes.contains("appAdmin") && roleCodes.contains(appAdminRoleCode) || roleCodes.contains(appDevOpsRoleCode));
    }

    public void buildTenantCondition(ConditionQueryRequest condition) {
        if (this.tenantEnabled.booleanValue() && !this.skipTenant()) {
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY)))) {
                this.logger.debug("set query condition tenant_id = " + (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY));
                condition.getConditions().getFields().add(new FieldCondition("tenant_id", ConditionOp.eq, (List)Lists.newArrayList((Object[])new String[]{(String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY)})));
            } else {
                condition.getConditions().getFields().add(new FieldCondition("tenant_id", ConditionOp.eq, (List)Lists.newArrayList((Object[])new String[]{""})));
            }
        }
    }

    public String getAppRoleCode(String roleSuffix) {
        AppItem appItem = this.metadataRepository.getCurrentApp();
        String code = StringUtils.isEmpty((CharSequence)appItem.getAppBranch()) ? appItem.getAppCode() : String.format("%s-%s", appItem.getAppCode(), appItem.getAppBranch());
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, code) + roleSuffix;
    }
}

