/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.admin.om.configuration;

import com.xforceplus.ultraman.extensions.admin.om.configuration.XplatTokenAuthentication;
import com.xforceplus.ultraman.extensions.admin.om.security.MyBasicAuthenticationEntryPoint;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.filter.OncePerRequestFilter;

@ConditionalOnProperty(value={"xplat.oqsengine.sdk.basic.enabled"}, matchIfMissing=true)
@EnableWebSecurity
public class CustomWebSecurityConfigurerAdapter {
    @Autowired
    private MyBasicAuthenticationEntryPoint authenticationEntryPoint;
    @Value(value="${xplat.oqsengine.sdk.basic.user:admin}")
    private String user;
    @Value(value="${xplat.oqsengine.sdk.basic.pass:xforceplus}")
    private String password;

    @Autowired
    public void configureGlobal(PasswordEncoder encoder, AuthenticationManagerBuilder auth) throws Exception {
        auth.inMemoryAuthentication().withUser(this.user).password(encoder.encode((CharSequence)this.password)).authorities(new String[]{"ROLE_USER"});
    }

    @Autowired
    @Order(value=1)
    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider(new AuthenticationProvider(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                authentication.setAuthenticated(true);
                return authentication;
            }

            public boolean supports(Class<?> authentication) {
                return authentication == XplatTokenAuthentication.class;
            }
        });
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        return (SecurityFilterChain)((HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeHttpRequests().antMatchers(new String[]{"/data-om/**"})).authenticated().and()).addFilterBefore((Filter)new OncePerRequestFilter(){

            protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
                Cookie[] cookies = request.getCookies();
                if (cookies != null && Arrays.stream(cookies).anyMatch(x -> x.getName().equalsIgnoreCase("xforce-saas-token") || x.getName().equalsIgnoreCase("xforce-app-token"))) {
                    XplatTokenAuthentication authResult = new XplatTokenAuthentication(null);
                    authResult.setAuthenticated(true);
                    SecurityContext context = SecurityContextHolder.createEmptyContext();
                    context.setAuthentication((Authentication)authResult);
                    SecurityContextHolder.setContext((SecurityContext)context);
                }
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }, BasicAuthenticationFilter.class).httpBasic().and()).authorizeHttpRequests().antMatchers(new String[]{"/**"})).permitAll().and()).build();
    }
}

