/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.admin.om.vo;

import com.xforceplus.ultraman.extensions.admin.om.enums.QErrorCode;

public class QDataResponse<T> {
    private static final long serialVersionUID = 1L;
    private long code;
    private T result;
    private String message;

    public static <T> QDataResponse<T> ok(T result) {
        QErrorCode aec = QErrorCode.SUCCESS;
        if (result instanceof Boolean && Boolean.FALSE.equals(result)) {
            aec = QErrorCode.FAILED;
        }
        return QDataResponse.restResult(result, aec);
    }

    public static <T> QDataResponse<T> fail(String msg) {
        return QDataResponse.restResult(null, QErrorCode.FAILED.getCode(), msg);
    }

    public static <T> QDataResponse<T> restResult(T result, QErrorCode errorCode) {
        return QDataResponse.restResult(result, errorCode.getCode(), errorCode.getMsg());
    }

    private static <T> QDataResponse<T> restResult(T result, long code, String msg) {
        QDataResponse<T> apiResult = new QDataResponse<T>();
        apiResult.setCode(code);
        apiResult.setResult(result);
        apiResult.setMessage(msg);
        return apiResult;
    }

    public long getCode() {
        return this.code;
    }

    public void setCode(long code) {
        this.code = code;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

