package com.xforceplus.ultraman.extensions.admin.om.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.extension.changelog.history.ChangelogFacade;
import com.xforceplus.ultraman.extension.changelog.history.impl.DefaultChangelogFacadeImpl;
import com.xforceplus.ultraman.extensions.admin.om.audit.EnableOmAuditLogAspect;
import com.xforceplus.ultraman.extensions.admin.om.controller.*;
import com.xforceplus.ultraman.extensions.admin.om.security.MyBasicAuthenticationEntryPoint;
import com.xforceplus.ultraman.extensions.admin.om.service.OmAuditLogService;
import com.xforceplus.ultraman.extensions.admin.om.service.impl.OmAuditLogServiceImpl;
import com.xforceplus.ultraman.extensions.admin.om.util.OmTenantUtil;
import com.xforceplus.ultraman.extensions.admin.web.OmController;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.graphql.config.GraphQLAutoConfiguration;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

import javax.sql.DataSource;

@AutoConfigureAfter(GraphQLAutoConfiguration.class)
@ConditionalOnProperty(value = "xplat.oqsengine.sdk.om.enabled", matchIfMissing = true)
public class OmAutoConfiguration {

    @Bean
    public OmTenantUtil omTenantUtil() {
        return new OmTenantUtil();
    }

    @Bean
    public OmController omController() {
        return new OmController();
    }

    @Bean
    public QOmBoApiController apiController() {
        return new QOmBoApiController();
    }

    @Bean
    public QOmDataController dataController() {
        return new QOmDataController();
    }

    @Bean
    public ChangelogFacade changelogFacade(@Qualifier("master") DataSource dataSource, EntityClassEngine engine, ObjectMapper mapper) {
        return new DefaultChangelogFacadeImpl(dataSource, engine, mapper);
    }

    @Bean
    public HistorylogController historylogController() {
        return new HistorylogController();
    }

    @Bean
    public ChangelogController changelogController() {
        return new ChangelogController();
    }

    @Bean
    public QOmBulkApiController bulkApiController() {
        return new QOmBulkApiController();
    }

    @Bean
    public QOmDictApiController qOmDictApiController() {
        return new QOmDictApiController();
    }

    @Bean
    public MyBasicAuthenticationEntryPoint authenticationEntryPoint() {
        return new MyBasicAuthenticationEntryPoint();
    }

    @Bean
    public EnableOmAuditLogAspect enableOmAuditLogAspect() {
        return new EnableOmAuditLogAspect();
    }

    @Bean
    public OmAuditLogService omAuditLogService(AuthConfig authConfig) {
        return new OmAuditLogServiceImpl(authConfig);
    }
}
