package com.xforceplus.ultraman.extensions.admin.om.configuration;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

import java.util.Collections;

public class XplatTokenAuthentication extends AbstractAuthenticationToken {

    private String token;

    /**
     * Creates a token with the supplied array of authorities.
     *
     * @param authorities the collection of <tt>GrantedAuthority</tt>s for the principal
     *                    represented by this authentication object.
     */
    public XplatTokenAuthentication(String token) {
        super(Collections.singleton(new SimpleGrantedAuthority("ROLE_USER")));
        this.token = token;
    }

    @Override
    public Object getCredentials() {
        return token;
    }

    @Override
    public Object getPrincipal() {
        return token;
    }
}
