package com.xforceplus.ultraman.extensions.admin.om.controller;

import com.xforceplus.ultraman.extension.changelog.history.ChangelogFacade;
import com.xforceplus.ultraman.extension.changelog.history.domain.HistoryEntity;
import com.xforceplus.ultraman.extension.changelog.history.domain.KeyBasedQuery;
import com.xforceplus.ultraman.metadata.domain.vo.Page;
import com.xforceplus.ultraman.metadata.domain.vo.dto.*;
import io.geewit.core.jackson.databind.serializer.RadioSerializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * changelog controller
 */
@RequestMapping("/data-om/historylog")
public class HistorylogController {

    @Autowired
    private ChangelogFacade changelogFacade;

    @PostMapping("/query")
    public ResponseEntity<Response<RowItem<HistoryEntity>>> queryDeleted(@RequestBody ConditionQueryRequest request) {
        try {
            KeyBasedQuery keyBasedQuery = toKey(request);
            Page<HistoryEntity> historyByEntityClass = changelogFacade.findHistoryByEntityClass(keyBasedQuery);
            return ResponseEntity.ok(toResponse(historyByEntityClass));
        } catch (Throwable throwable) {
            Response response = new Response();
            response.setCode("0");
            response.setMessage(throwable.getMessage());
            response.setResult(Collections.emptyList());
            return ResponseEntity.status(500).body(response);
        }
    }

    private Response<RowItem<HistoryEntity>> toResponse(Page<HistoryEntity> histories) {
        Response<RowItem<HistoryEntity>> response = new Response<>();
        response.setCode("1");
        RowItem<HistoryEntity> rowItem = new RowItem<>();
        rowItem.setRows(histories.getRows());
        SummaryItem summaryItem = new SummaryItem();
        summaryItem.setTotal((int) histories.getSummary().getTotal());
        rowItem.setSummary(summaryItem);
        response.setResult(rowItem);
        return response;
    }

    private KeyBasedQuery toKey(ConditionQueryRequest request) {
        KeyBasedQuery keyBasedQuery = new KeyBasedQuery();
        Conditions conditions = request.getConditions();
        if(conditions != null) {
            List<FieldCondition> fields = conditions.getFields();
            Optional<FieldCondition> boId = fields.stream().filter(x -> x.getCode().equalsIgnoreCase("bo_id")).findFirst();
            boId.ifPresent(fieldCondition -> keyBasedQuery.setEntityClassId(Long.parseLong(fieldCondition.getValue().get(0))));

            Optional<FieldCondition> key1 = fields.stream().filter(x -> x.getCode().equalsIgnoreCase("key1")).findFirst();
            key1.ifPresent(con -> keyBasedQuery.setKeys1(con.getValue().get(0)));

            Optional<FieldCondition> id = fields.stream().filter(x -> x.getCode().equalsIgnoreCase("id")).findFirst();
            id.ifPresent(con -> keyBasedQuery.setId(Long.parseLong(con.getValue().get(0))));
        }

        Integer pageNo = request.getPageNo();
        Integer pageSize = request.getPageSize();

        keyBasedQuery.setPage(pageNo);
        keyBasedQuery.setSize(pageSize);

        if(keyBasedQuery.getEntityClassId() == 0) {
            throw new RuntimeException("请选择对应的对象");
        }
        return keyBasedQuery;
    }
}
