package com.xforceplus.ultraman.extensions.admin.om.enums;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   youyifan
 * 创建时间: 7/28/2020 2:58 PM
 * 功能描述:
 * 修改历史:
 */
public enum QErrorCode {
    /**
     * 失败
     */
    FAILED(-1, "操作失败"),
    /**
     * 成功
     */
    SUCCESS(0, "执行成功");

    private final long code;
    private final String msg;

    QErrorCode(final long code, final String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static QErrorCode fromCode(long code) {
        QErrorCode[] ecs = QErrorCode.values();
        for (QErrorCode ec : ecs) {
            if (ec.getCode() == code) {
                return ec;
            }
        }
        return SUCCESS;
    }

    public long getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    @Override
    public String toString() {
        return String.format(" ErrorCode:{code=%s, msg=%s} ", code, msg);
    }
}
