/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.admin.om.audit;

import com.alibaba.fastjson.JSON;
import com.xforceplus.ultraman.extensions.admin.om.audit.OmAuditLog;
import com.xforceplus.ultraman.extensions.admin.om.enums.QOperateType;
import com.xforceplus.ultraman.extensions.admin.om.service.OmAuditLogService;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Response;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;

@Aspect
public class EnableOmAuditLogAspect {
    @Value(value="${xplat.meta.oqsengine.data.om.audit-log.enabled:true}")
    private Boolean auditLogEnabled;
    @Autowired
    private EntityClassEngine engine;
    @Autowired
    private OmAuditLogService omAuditLogService;

    @AfterReturning(value="@annotation(com.xforceplus.ultraman.extensions.admin.om.audit.EnableOmAuditLog)", returning="result")
    public Object afterRunning(JoinPoint joinPoint, Object result) {
        if (this.auditLogEnabled == null || !this.auditLogEnabled.booleanValue()) {
            return result;
        }
        Object[] args = joinPoint.getArgs();
        OmAuditLog omAuditLog = new OmAuditLog();
        omAuditLog.setBoId(this.getLong(args[0]));
        if (omAuditLog.getBoId() != null) {
            this.engine.load(omAuditLog.getBoId().toString(), "").ifPresent(entityClass -> {
                omAuditLog.setBoCode(entityClass.code());
                omAuditLog.setBoName(entityClass.name());
            });
        }
        switch (joinPoint.getSignature().getName()) {
            case "singleDelete": {
                omAuditLog.setEntityId(String.valueOf(args[1]));
                omAuditLog.setOperateType(QOperateType.SINGLE_DELETE.name());
                break;
            }
            case "singleCreate": {
                omAuditLog.setOperateType(QOperateType.SINGLE_CREATE.name());
                omAuditLog.setEntityId((String)((Response)((ResponseEntity)result).getBody()).getResult());
                break;
            }
            case "singleModify": {
                omAuditLog.setEntityId(String.valueOf(args[1]));
                omAuditLog.setOperateType(QOperateType.SINGLE_MODIFY.name());
                break;
            }
            case "importEntities": {
                omAuditLog.setOperateType(QOperateType.IMPORT.name());
                args[2] = null;
                break;
            }
            case "batchDelete": {
                omAuditLog.setOperateType(QOperateType.BATCH_DELETE.name());
                break;
            }
            case "batchModify": {
                omAuditLog.setOperateType(QOperateType.BATCH_MODIFY.name());
                break;
            }
            case "batchModifyAll": {
                omAuditLog.setOperateType(QOperateType.BATCH_MODIFY_ALL.name());
                break;
            }
        }
        omAuditLog.setRequestData(JSON.toJSONString((Object)args));
        omAuditLog.setResponseData(JSON.toJSONString((Object)((ResponseEntity)result).getBody()));
        this.omAuditLogService.saveUseSysBo(omAuditLog);
        return result;
    }

    private Long getLong(Object arg) {
        if (arg instanceof Long) {
            return (Long)arg;
        }
        if (arg instanceof String) {
            return Long.valueOf((String)arg);
        }
        return null;
    }
}

