/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.admin.om.controller;

import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.core.dispatcher.messaging.GenericQueryMessage;
import com.xforceplus.tech.base.core.dispatcher.messaging.QueryMessage;
import com.xforceplus.ultraman.extensions.admin.om.audit.EnableOmAuditLog;
import com.xforceplus.ultraman.extensions.admin.om.util.CommonUtil;
import com.xforceplus.ultraman.extensions.admin.om.util.OmTenantUtil;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Conditions;
import com.xforceplus.ultraman.metadata.domain.vo.dto.EntityItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.NameMapping;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Response;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.controller.constants.SDKContextKey;
import com.xforceplus.ultraman.sdk.core.bulk.BulkService;
import com.xforceplus.ultraman.sdk.core.bulk.importer.enums.ImportModeEnum;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionExportCmd;
import com.xforceplus.ultraman.sdk.core.cmd.ExportCmdQuery;
import com.xforceplus.ultraman.sdk.core.cmd.GetImportTemplateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.ImportCmd;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpFactory;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@ResponseBody
@RequestMapping(value={"api/0/${xplat.oqsengine.sdk.auth.appcode:global}/data-om", "/data-om"})
public class QOmBulkApiController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int exportMaxSize = 10000;
    @Autowired
    private ContextService contextService;
    @Autowired
    private ProfileFetcher fetcher;
    @Autowired
    private OmTenantUtil omTenantUtil;
    @Autowired
    private BulkService bulkService;
    @Autowired
    private EntityClassEngine metadataRepository;

    @PostMapping(value={"/bos/{boId}/entities/export"})
    @ResponseBody
    public CompletableFuture<Response<String>> conditionExport(@PathVariable String boId, @RequestParam(defaultValue="sync", value="exportType") String exportType, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="appId") String appId, @RequestParam(required=false, value="skip", defaultValue="false") boolean skip, @RequestParam(required=false, value="pageCode") String pageCode, @RequestParam(required=false, value="fileName") String specifyFileName, @RequestParam(required=false, value="type", defaultValue="xls") String exportFileType, @RequestParam(required=false, value="profile") String profile, @RequestBody ConditionQueryRequest condition) {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set((ContextService.ContextKey)SDKContextKey.PAGE, (Object)page);
        if (!StringUtils.isEmpty((CharSequence)profile)) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)profile);
        }
        if (condition != null) {
            if (condition.getPageNo() == null) {
                condition.setPageNo(Integer.valueOf(1));
            }
            if (condition.getPageSize() == null || condition.getPageSize() > this.exportMaxSize) {
                condition.setPageSize(Integer.valueOf(this.exportMaxSize));
            }
        }
        this.omTenantUtil.buildTenantCondition(condition);
        Optional simpleBo = this.metadataRepository.load(boId, "");
        String name = simpleBo.map(entityClass -> StringUtils.isEmpty((CharSequence)entityClass.name()) ? entityClass.code() : entityClass.name()).orElse(null);
        HashMap<String, String> exportMap = new HashMap<String, String>();
        exportMap.put("name", name);
        HashMap<String, ExportCmdQuery> map = new HashMap<String, ExportCmdQuery>();
        map.put(boId, this.toExportCmdQuery(condition));
        GenericQueryMessage queryMessage = new GenericQueryMessage((Object)new ConditionExportCmd(boId, version, exportType, exportFileType, appId, map, specifyFileName, (String)Optional.ofNullable(condition).map(ConditionQueryRequest::getAttachment).orElse(null), skip), null, exportMap);
        CompletableFuture exportResult = this.bulkService.conditionExport((QueryMessage)queryMessage);
        return exportResult.thenApply(x -> {
            if (x.isRight()) {
                Response response = new Response();
                response.setResult(x.get());
                response.setMessage("OK");
                response.setCode("1");
                return response;
            }
            return Response.Error((String)((String)x.getLeft()));
        });
    }

    @GetMapping(value={"/bos/{boId}/entities/import/template"})
    @ResponseBody
    public ResponseEntity<StreamingResponseBody> importTemplate(@PathVariable String boId, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="pageCode") String pageCode, @RequestParam(required=false, value="profile") String profile) {
        Either importTemplate;
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set((ContextService.ContextKey)SDKContextKey.PAGE, (Object)page);
        if (!StringUtils.isEmpty((CharSequence)profile)) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)profile);
        }
        if ((importTemplate = this.bulkService.importTemplate(new GetImportTemplateCmd(boId, version))).isRight()) {
            InputStream finalInput = (InputStream)((Tuple2)importTemplate.get())._2();
            StreamingResponseBody responseBody = outputStream -> {
                StreamUtils.copy((InputStream)finalInput, (OutputStream)outputStream);
                outputStream.close();
            };
            String encodedName = (String)((Tuple2)importTemplate.get())._1();
            try {
                encodedName = URLEncoder.encode((String)((Tuple2)importTemplate.get())._1(), "UTF-8");
            }
            catch (UnsupportedEncodingException var10) {
                this.logger.error("{}", (Throwable)var10);
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + encodedName})).body((Object)responseBody);
        }
        this.logger.error("Download template failed {}", importTemplate.getLeft());
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
    }

    @EnableOmAuditLog
    @PostMapping(value={"/bos/{boId}/entities/import"})
    @ResponseBody
    public ResponseEntity<Response<String>> importEntities(@PathVariable String boId, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="pageCode") String pageCode, @RequestParam(required=false, value="timeout", defaultValue="300000") int timeout, @RequestParam(required=false, value="step", defaultValue="1000") int step, @RequestParam(required=false, value="async", defaultValue="true") boolean isAsync, @RequestParam(required=false, value="appId") String appId, @RequestParam(required=false, value="useBatch", defaultValue="true") boolean useBatch, @RequestParam(required=false, value="profile") String profile, MultipartFile file) throws IOException {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set((ContextService.ContextKey)SDKContextKey.PAGE, (Object)page);
        if (!StringUtils.isEmpty((CharSequence)profile)) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)profile);
        }
        String extension = FilenameUtils.getExtension((String)Optional.ofNullable(file.getOriginalFilename()).orElse(file.getName()));
        Either result = this.bulkService.batchImport(new ImportCmd(boId, version, file.getInputStream(), extension, file.getOriginalFilename(), timeout, step, isAsync, appId, null, null, ImportModeEnum.BASE.getCode(), Boolean.valueOf(useBatch)));
        ResponseEntity<Response<String>> resp = (ResponseEntity<Response<String>>)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response rep = new Response();
            rep.setCode("1");
            rep.setResult(x);
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok((Object)rep);
        }).getOrElseGet(str -> {
            Response rep = new Response();
            rep.setCode("-1");
            rep.setMessage("\u64cd\u4f5c\u5931\u8d25:".concat((String)str));
            rep.setResult(str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)rep);
        });
        return resp.getStatusCode().is2xxSuccessful() ? CommonUtil.buildSuccessResp(file.getOriginalFilename()) : resp;
    }

    private ExportCmdQuery toExportCmdQuery(ConditionQueryRequest condition) {
        ExportCmdQuery exportQuery = new ExportCmdQuery();
        exportQuery.setMainQuery((ExpRel)ExpFactory.createFrom((ConditionQueryRequest)condition));
        exportQuery.setMainMapping(condition.getMapping());
        List toManyRelations = condition.getToManyRelations();
        HashMap subQuery = new HashMap();
        HashMap subNameMapping = new HashMap();
        Optional.ofNullable(toManyRelations).orElseGet(Collections::emptyList).stream().map(x -> {
            String code = x.getCode();
            String name = x.getName();
            NameMapping nm = new NameMapping();
            nm.setCode(code);
            nm.setText(name);
            ExpQuery expQuery = ExpFactory.createFrom((Conditions)x.getConditions(), (EntityItem)x.getEntity(), (List)x.getMapping(), (List)x.getSort(), null, null);
            List nameMapping = x.getMapping();
            ArrayList<NameMapping> newNameMapping = new ArrayList<NameMapping>(nameMapping);
            newNameMapping.add(nm);
            return Tuple.of((Object)code, (Object)expQuery, newNameMapping);
        }).forEach(x -> {
            subQuery.put(x._1, x._2);
            subNameMapping.put(x._1, x._3);
        });
        exportQuery.setSubMapping(subNameMapping);
        exportQuery.setSubQuery(subQuery);
        return exportQuery;
    }
}

