/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.admin.om.service.impl;

import com.google.common.collect.Maps;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.extensions.admin.om.audit.OmAuditLog;
import com.xforceplus.ultraman.extensions.admin.om.service.OmAuditLogService;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.cmd.SingleCreateCmd;
import com.xforceplus.ultraman.sdk.core.service.EntityHandlerService;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import io.vavr.control.Either;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class OmAuditLogServiceImpl
implements OmAuditLogService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String AUDIT_BO_CODE = "oqsengineSdkOmAuditLog";
    private AuthConfig authConfig;
    @Autowired
    private EntityClassEngine entityService;
    @Autowired
    @Qualifier(value="entityServiceHandler")
    private EntityHandlerService defaultEntityServiceHandler;
    @Autowired
    private ContextService contextService;

    public OmAuditLogServiceImpl(AuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    @Override
    public int saveUseSysBo(OmAuditLog auditLog) {
        Optional auditBoEntityClassOptl = this.entityService.loadByCode("oqsengineSdkOmAuditLog", "");
        if (auditBoEntityClassOptl.isPresent()) {
            HashMap body = Maps.newHashMap();
            body.put("app_id", this.authConfig.getAppId());
            body.put("app_code", this.entityService.getCurrentApp() == null ? null : this.entityService.getCurrentApp().getAppCode());
            body.put("bo_id", auditLog.getBoId());
            body.put("bo_code", auditLog.getBoCode());
            body.put("bo_name", auditLog.getBoName());
            body.put("entity_id", auditLog.getEntityId());
            body.put("operate_type", auditLog.getOperateType());
            body.put("request_data", auditLog.getRequestData());
            body.put("response_data", auditLog.getResponseData());
            body.put("remark", auditLog.getRemark());
            body.put("operate_time", System.currentTimeMillis());
            body.put("operator_id", this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.ID));
            body.put("operator_code", this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USERNAME));
            body.put("operator_name", this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USER_DISPLAYNAME));
            body.put("tenant_id", this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.TENANT_ID));
            body.put("tenant_code", this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY));
            Either result = this.defaultEntityServiceHandler.singleCreate(new SingleCreateCmd(String.valueOf(((IEntityClass)auditBoEntityClassOptl.get()).id()), (Map)body, null));
            return (Integer)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> 1).getOrElseGet(x -> 0);
        }
        return 0;
    }
}

