package com.xforceplus.ultraman.extensions.admin.om.configuration;

import com.xforceplus.ultraman.extensions.admin.om.security.MyBasicAuthenticationEntryPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;

@ConditionalOnProperty(value = "xplat.oqsengine.sdk.basic.enabled", matchIfMissing = true)
@EnableWebSecurity
public class CustomWebSecurityConfigurerAdapter {

    @Autowired
    private MyBasicAuthenticationEntryPoint authenticationEntryPoint;

    @Value("${xplat.oqsengine.sdk.basic.user:admin}")
    private String user;

    @Value("${xplat.oqsengine.sdk.basic.pass:xforceplus}")
    private String password;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth
                .inMemoryAuthentication()
                .withUser(user)
                .password(passwordEncoder().encode(password))
                .authorities("ROLE_USER");
    }

    @Autowired
    @Order(1)
    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider(new AuthenticationProvider() {
            @Override
            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                authentication.setAuthenticated(true);
                return authentication;
            }

            @Override
            public boolean supports(Class<?> authentication) {
                return authentication == XplatTokenAuthentication.class;
            }
        });
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        return http.csrf().disable()
                .authorizeHttpRequests().antMatchers("/data-om/**").authenticated().and()
                .addFilterBefore(new OncePerRequestFilter() {
                    @Override
                    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
                        Cookie[] cookies = request.getCookies();
                        if (cookies != null && Arrays.stream(cookies
                        ).anyMatch(x -> x.getName()
                                .equalsIgnoreCase("xforce-saas-token") || x.getName().equalsIgnoreCase("xforce-app-token"))) {
                            Authentication authResult = new XplatTokenAuthentication(null);
                            authResult.setAuthenticated(true);
                            SecurityContext context = SecurityContextHolder.createEmptyContext();
                            context.setAuthentication(authResult);
                            SecurityContextHolder.setContext(context);
                        }

                        chain.doFilter(request, response);
                    }
                }, BasicAuthenticationFilter.class)
                .httpBasic()
                .and()
                .authorizeHttpRequests().antMatchers("/**").permitAll()
                .and()
                .build();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }
}