package com.xforceplus.ultraman.extensions.admin.om.controller;

import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.core.dispatcher.messaging.GenericQueryMessage;
import com.xforceplus.ultraman.extensions.admin.om.audit.EnableOmAuditLog;
import com.xforceplus.ultraman.extensions.admin.om.util.CommonUtil;
import com.xforceplus.ultraman.extensions.admin.om.util.OmTenantUtil;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.domain.vo.dto.NameMapping;
import com.xforceplus.ultraman.metadata.domain.vo.dto.RelationQuery;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Response;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.controller.constants.SDKContextKey;
import com.xforceplus.ultraman.sdk.core.bulk.BulkService;
import com.xforceplus.ultraman.sdk.core.bulk.importer.domain.ImportResult;
import com.xforceplus.ultraman.sdk.core.bulk.importer.enums.ImportModeEnum;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionExportCmd;
import com.xforceplus.ultraman.sdk.core.cmd.ExportCmdQuery;
import com.xforceplus.ultraman.sdk.core.cmd.GetImportTemplateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.ImportCmd;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpFactory;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.*;
import java.util.concurrent.CompletableFuture;

import static com.xforceplus.ultraman.sdk.controller.constants.Constants.FAILED;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 1/26/2021 1:54 PM
 * @description:
 * @history:
 */
@ResponseBody
@RequestMapping(value = {"api/0/${xplat.oqsengine.sdk.auth.appcode:global}/data-om","/data-om"})
public class QOmBulkApiController {
    private Logger logger = LoggerFactory.getLogger(getClass());

    private int exportMaxSize = 10000;

    @Autowired
    private ContextService contextService;

    @Autowired
    private ProfileFetcher fetcher;

    @Autowired
    private OmTenantUtil omTenantUtil;
    @Autowired
    private BulkService bulkService;
    @Autowired
    private EntityClassEngine metadataRepository;

    @PostMapping({"/bos/{boId}/entities/export"})
    @ResponseBody
    public CompletableFuture<Response<String>> conditionExport(@PathVariable String boId,
                                                               @RequestParam(defaultValue = "sync", value = "exportType") String exportType,
                                                               @RequestParam(required = false, value = "v") String version,
                                                               @RequestParam(required = false, value = "appId") String appId,
                                                               @RequestParam(required = false, value = "skip", defaultValue = "false") boolean skip,
                                                               @RequestParam(required = false, value = "pageCode") String pageCode,
                                                               @RequestParam(required = false, value = "fileName") String specifyFileName,
                                                               @RequestParam(required = false, value = "type", defaultValue = "xls") String exportFileType,
                                                               @RequestParam(required = false, value = "profile") String profile,
                                                               @RequestBody ConditionQueryRequest condition) {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set(SDKContextKey.PAGE, page);
        if(!StringUtils.isEmpty(profile)) {
            this.contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, profile);
        }

        if (condition != null) {
            if (condition.getPageNo() == null) {
                condition.setPageNo(1);
            }

            if (condition.getPageSize() == null || condition.getPageSize() > this.exportMaxSize) {
                condition.setPageSize(this.exportMaxSize);
            }
        }
        //租户隔离
        omTenantUtil.buildTenantCondition(condition);

        Optional<IEntityClass> simpleBo = metadataRepository.load(boId, "");
        String name = simpleBo.map(entityClass -> (StringUtils.isEmpty(entityClass.name()) ? entityClass.code() : entityClass.name())).orElse(null);
        Map<String, String> exportMap = new HashMap();
        exportMap.put("name", name);

        Map<String, ExportCmdQuery> map = new HashMap();
        map.put(boId, this.toExportCmdQuery(condition));
        GenericQueryMessage queryMessage =
                new GenericQueryMessage(new ConditionExportCmd(boId, version, exportType, exportFileType, appId, map, specifyFileName
                        , Optional.ofNullable(condition).map(ConditionQueryRequest::getAttachment).orElse(null), skip)
                        , null
                        , exportMap);
        CompletableFuture<Either<String, String>> exportResult = (CompletableFuture) bulkService.conditionExport(queryMessage);
        return exportResult.thenApply((x) -> {
            if (x.isRight()) {
                Response<String> response = new Response();
                response.setResult(x.get());
                response.setMessage("OK");
                response.setCode("1");
                return response;
            } else {
                return Response.Error(x.getLeft());
            }
        });
    }


    @GetMapping({"/bos/{boId}/entities/import/template"})
    @ResponseBody
    public ResponseEntity<StreamingResponseBody> importTemplate(@PathVariable String boId, @RequestParam(required = false, value = "v") String version,
                                                                @RequestParam(required = false, value = "pageCode") String pageCode, @RequestParam(required = false, value = "profile") String profile) {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set(SDKContextKey.PAGE, page);
        if(!StringUtils.isEmpty(profile)) {
            this.contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, profile);
        }
        Either<String, Tuple2<String, InputStream>> importTemplate = bulkService.importTemplate(new GetImportTemplateCmd(boId, version));
        if (importTemplate.isRight()) {
            InputStream finalInput = (InputStream) ((Tuple2) importTemplate.get())._2();
            StreamingResponseBody responseBody = (outputStream) -> {
                StreamUtils.copy(finalInput, outputStream);
                outputStream.close();
            };
            String encodedName = (String) ((Tuple2) importTemplate.get())._1();

            try {
                encodedName = URLEncoder.encode((String) ((Tuple2) importTemplate.get())._1(), "UTF-8");
            } catch (UnsupportedEncodingException var10) {
                this.logger.error("{}", var10);
            }

            return ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + encodedName}).body(responseBody);
        } else {
            this.logger.error("Download template failed {}", importTemplate.getLeft());
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @EnableOmAuditLog
    @PostMapping({"/bos/{boId}/entities/import"})
    @ResponseBody
    public ResponseEntity<Response<String>> importEntities(
            @PathVariable String boId
            , @RequestParam(required = false, value = "v") String version
            , @RequestParam(required = false, value = "pageCode") String pageCode
            , @RequestParam(required = false, value = "timeout", defaultValue = "300000") int timeout
            , @RequestParam(required = false, value = "step", defaultValue = "1000") int step
            , @RequestParam(required = false, value = "async", defaultValue = "true") boolean isAsync
            , @RequestParam(required = false, value = "appId") String appId
            , @RequestParam(required = false, value = "useBatch", defaultValue = "true") boolean useBatch
            , @RequestParam(required = false, value = "profile") String profile
            , MultipartFile file
    ) throws IOException {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set(SDKContextKey.PAGE, page);
        if(!StringUtils.isEmpty(profile)) {
            this.contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, profile);
        }
        String extension = FilenameUtils.getExtension(Optional.ofNullable(file.getOriginalFilename()).orElse(file.getName()));
        Either<String, String> result = bulkService.batchImport(new ImportCmd(boId, version, file.getInputStream(), extension
                , file.getOriginalFilename(), timeout, step, isAsync, appId, null, null, ImportModeEnum.BASE.getCode(), useBatch));
        ResponseEntity<Response<String>> resp = Optional.ofNullable(result).orElseGet(() -> {
            return Either.left("没有返回值");
        }).map((x) -> {
            Response<String> rep = new Response();
            rep.setCode("1");
            rep.setResult(x);
            rep.setMessage("操作成功");
            return ResponseEntity.ok(rep);
        }).getOrElseGet((str) -> {
            Response<String> rep = new Response();
            rep.setCode("-1");
            rep.setMessage(FAILED.concat(str));
            rep.setResult(str);
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        });
        return resp.getStatusCode().is2xxSuccessful() ? CommonUtil.buildSuccessResp(file.getOriginalFilename()) : resp;
    }


    private ExportCmdQuery toExportCmdQuery(ConditionQueryRequest condition) {
        ExportCmdQuery exportQuery = new ExportCmdQuery();
        exportQuery.setMainQuery(ExpFactory.createFrom(condition));
        exportQuery.setMainMapping(condition.getMapping());
        List<RelationQuery> toManyRelations = condition.getToManyRelations();
        Map<String, ExpRel> subQuery = new HashMap();
        Map<String, List<NameMapping>> subNameMapping = new HashMap();
        Optional.ofNullable(toManyRelations).orElseGet(Collections::emptyList).stream().map(x -> {
            String code = x.getCode();
            String name = x.getName();
            NameMapping nm = new NameMapping();
            nm.setCode(code);
            nm.setText(name);
            ExpRel expQuery = ExpFactory.createFrom(x.getConditions(), x.getEntity(), x.getMapping(), x.getSort(), null, null);
            List<NameMapping> nameMapping = x.getMapping();
            List<NameMapping> newNameMapping = new ArrayList(nameMapping);
            newNameMapping.add(nm);
            return Tuple.of(code, expQuery, newNameMapping);
        }).forEach((x) -> {
            subQuery.put(x._1, x._2);
            subNameMapping.put(x._1, x._3);
        });
        exportQuery.setSubMapping(subNameMapping);
        exportQuery.setSubQuery(subQuery);
        return exportQuery;
    }

}
