package com.xforceplus.ultraman.extensions.admin.om.controller;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.extensions.admin.om.audit.EnableOmAuditLog;
import com.xforceplus.ultraman.extensions.admin.om.enums.QErrorCode;
import com.xforceplus.ultraman.extensions.admin.om.util.CommonUtil;
import com.xforceplus.ultraman.extensions.admin.om.vo.*;
import com.xforceplus.ultraman.metadata.domain.vo.dto.FieldItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Response;
import com.xforceplus.ultraman.metadata.domain.vo.dto.RowItem;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   youyifan
 * 创建时间: 7/28/2020 11:02 AM
 * 功能描述:
 * 修改历史:
 */
@ResponseBody
@RequestMapping(value = {"api/0/${xplat.oqsengine.sdk.auth.appcode:global}/data-om","/data-om"})
public class QOmDataController {

    private Logger logger = LoggerFactory.getLogger(getClass());

    private final String AUDIT_BO_CODE = "oqsengineSdkOmAuditLog";

    private final List<String> SYSTEM_BOS = Arrays.asList("oqsengineSdkOmAuditLog");

    @Autowired
    private ContextService contextService;

    @Autowired
    private QOmBoApiController qOmBoApiController;

    @Autowired
    private EntityClassEngine engine;

    @Autowired
    private ProfileFetcher fetcher;

    @Autowired
    private DynamicConfig dynamicConfig;

    @Value("${xplat.meta.oqsengine.data.om.modify-limit:50000}")
    private Integer modifyLimit;

//    private List<QBoApiVo> defaultBoApis = Lists.newArrayList(
//            new QBoApiVo(null, "查询", "query", "/api/{tenantId}/%s/bos/%d/entities/query", "post"),
//            new QBoApiVo(null, "单个查询", "queryOne", "/api/{tenantId}/%s/bos/%d/entities/{id}", "get"),
//            new QBoApiVo(null, "创建", "create", "/api/{tenantId}/%s/bos/%d/entities", "post"),
//            new QBoApiVo(null, "修改", "update", "/api/{tenantId}/%s/bos/%d/entities/{id}", "put"),
//            new QBoApiVo(null, "删除", "delete", "/api/{tenantId}/%s/bos/%d/entities/{id}", "delete"),
//            new QBoApiVo(null, "导入", "import", "/api/{tenantId}/%s/bos/%d/entities/import", "post"),
//            new QBoApiVo(null, "导出", "export", "/api/{tenantId}/%s/bos/%d/entities/export", "post"),
//            new QBoApiVo(null, "导入模板", "importTemplate", "/api/{tenantId}/%s/bos/%d/entities/import/template", "get")
//    );

    private List<QBoApiVo> defaultBoApis = Lists.newArrayList(
            new QBoApiVo(null, "查询", "query", "/data-om/bos/%d/entities/query", "post"),
            new QBoApiVo(null, "单个查询", "queryOne", "/data-om/bos/%d/entities/{id}", "get"),
            new QBoApiVo(null, "创建", "create", "/data-om/bos/%d/entities", "post"),
            new QBoApiVo(null, "修改", "update", "/data-om/bos/%d/entities/{id}", "put"),
            new QBoApiVo(null, "删除", "delete", "/data-om/bos/%d/entities/{id}", "delete"),
            new QBoApiVo(null, "导入", "import", "/data-om/bos/%d/entities/import", "post"),
            new QBoApiVo(null, "导出", "export", "/data-om/bos/%d/entities/export", "post"),
            new QBoApiVo(null, "导入模板", "importTemplate", "/data-om/bos/%d/entities/import/template", "get")
    );

    @EnableOmAuditLog
    @DeleteMapping({"/bos/{boId}/entities"})
    public ResponseEntity<Response<Object>> batchDelete(@PathVariable String boId, @RequestBody QDeletePayload payload, @RequestParam(required = false, value = "v") String version
            , @RequestParam(required = false, value = "profile") String profile) {
        logger.info("batch delete payload: " + JSON.toJSONString(payload));

        if(!StringUtils.isEmpty(profile)) {
            this.contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, profile);
        }
        Map<String, String> respMap = Maps.newHashMap();
        for (String id : payload.getIncludes()) {
            ResponseEntity<Response<String>> res = qOmBoApiController.singleDelete(boId, id, version, null, profile);
            respMap.put(id, res.getBody().getCode());
            if (200 != res.getStatusCode().value() && 202 != res.getStatusCode().value()) {
                logger.error("boId:{}, id:{}, msg:{}", boId, id, res.getBody().getMessage());
            }
        }
        return CommonUtil.buildSuccessResp(respMap);
    }

    @EnableOmAuditLog
    @PutMapping({"/bos/{boId}/entities"})
    public ResponseEntity<Response<Object>> batchModify(@PathVariable String boId, @RequestParam(required = false, value = "v") String version
            , @RequestBody QModifyPayload modifyPayload, @RequestParam(required = false, value = "profile") String profile) {
        logger.info("batch modify payload: " + JSON.toJSONString(modifyPayload));
        if(!StringUtils.isEmpty(profile)) {
            this.contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, profile);
        }
        Map<String, String> respMap = Maps.newHashMap();
        for (String id : modifyPayload.getIncludes()) {
            Map<String, Object> body = modifyPayload.getBody();
            body.put("id", id);
            ResponseEntity<Response<String>> res = qOmBoApiController.singleModify(boId, Long.parseLong(id), version, body, profile);
            respMap.put(id, res.getBody().getCode());
            if (200 != res.getStatusCode().value() && 202 != res.getStatusCode().value()) {
                logger.error("boId:{}, id:{}, msg:{}", boId, id, res.getBody().getMessage());
            }
        }
        return CommonUtil.buildSuccessResp(respMap);
    }

    @EnableOmAuditLog
    @PutMapping({"/bos/{boId}/entities/all"})
    public ResponseEntity<Response<Object>> batchModifyAll(@PathVariable String boId, @RequestParam(required = false, value = "v") String version
            , @RequestBody QConditionModifyPayload modifyPayload, @RequestParam(required = false, value = "profile") String profile) {

        if(!StringUtils.isEmpty(profile)) {
            this.contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, profile);
        }

        if (null == modifyPayload.getCondition() || null == modifyPayload.getCondition().getConditions()
            || null == modifyPayload.getCondition().getConditions().getFields()
            || modifyPayload.getCondition().getConditions().getFields().isEmpty()) {
            return new ResponseEntity<>(Response.Error("请添加筛选条件"), null, HttpStatus.ACCEPTED);
        }

        modifyPayload.getCondition().setPageNo(1);
        modifyPayload.getCondition().setPageSize(10000);
        ResponseEntity<Response<RowItem<Map<String, Object>>>> result = qOmBoApiController.conditionQuery(boId, version, modifyPayload.getCondition(), null, profile);
        List<Map<String, Object>> rows = result.getBody().getResult().getRows();
        if (rows.size() > modifyLimit) {
            return new ResponseEntity<>(Response.Error("筛选结果超过修改上限" + modifyLimit + "条"), HttpStatus.ACCEPTED);
        }

        logger.info("batch modify all datas: " + JSON.toJSONString(rows));
        Map<Object, String> respMap = Maps.newHashMap();
        for (Map<String, Object> row : rows) {
            Map<String, Object> body = modifyPayload.getBody();
            body.put("id", row.get("id"));
            ResponseEntity<Response<String>> res = qOmBoApiController.singleModify(boId, Long.parseLong((String) row.get("id")), version, body, profile);
            respMap.put(row.get("id"), res.getBody().getCode());
            if (200 != res.getStatusCode().value() && 202 != res.getStatusCode().value()) {
                logger.error("boId:{}, id:{}, msg:{}", boId, row.get("id"), res.getBody().getMessage());
            }
        }
        return CommonUtil.buildSuccessResp(respMap);
    }

    /**
     * 查看对象列表
     *
     * @return
     */
    @GetMapping({"/bos"})
    public QDataResponse<QPageInfo> queryBos(@RequestParam(required = false, value = "profile") String profileInput, QPageVo queryBoVo) {
        if(!StringUtils.isEmpty(profileInput)) {
            this.contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, profileInput);
        }

        String profile = fetcher.getProfile(Collections.emptyMap());
        List<IEntityClass> entityClasss = engine.findAllEntities(profile);
        if (!StringUtils.isEmpty(queryBoVo.getText())) {
            entityClasss = entityClasss.stream()
                .filter(entityClass -> entityClass.name().contains(queryBoVo.getText()) ||
                    entityClass.code().contains(queryBoVo.getText()))
                .collect(Collectors.toList());
        }

        List<QBoInfo> qBoInfos = entityClasss.stream()
            .filter(entityClass -> !SYSTEM_BOS.contains(entityClass.code()))
            .map(entityClass -> {
                QBoInfo qBoInfo = new QBoInfo();
                qBoInfo.setId(entityClass.id());
                qBoInfo.setCode(entityClass.code());
                qBoInfo.setName(entityClass.name());

                String parentBoNames = "";
                IEntityClass extendEntityClass = null;
                if (entityClass.extendEntityClass() != null) {
                    parentBoNames = entityClass.extendEntityClass().code();
                    extendEntityClass = engine.loadByCode(entityClass.extendEntityClass().code(), profile).orElse(null);
                }
                while (extendEntityClass != null && extendEntityClass.extendEntityClass() != null) {
                    parentBoNames += "/" + extendEntityClass.extendEntityClass().code();
                    extendEntityClass = engine.loadByCode(extendEntityClass.extendEntityClass().code(), "").orElse(null);
                }
                qBoInfo.setParentBoName(parentBoNames);

                String relationBoNames = "";
                if (entityClass.entityClasses() != null) {
                    relationBoNames = entityClass.entityClasses()
                        .stream().map(IEntityClass::code).distinct().sorted().collect(Collectors.joining("/"));
                }
                String pRelationBoNames = "";
                if (entityClass.extendEntityClass() != null && entityClass.extendEntityClass().entityClasses() != null) {
                    pRelationBoNames = entityClass.extendEntityClass().entityClasses()
                        .stream().map(IEntityClass::code).distinct().sorted().collect(Collectors.joining("/"));
                }
                qBoInfo.setRelationBoNames(getRelationBoNames(relationBoNames, pRelationBoNames));

                return qBoInfo;
            }).collect(Collectors.toList());

        int offset = (queryBoVo.getCurrent() - 1) * queryBoVo.getSize();
        if (qBoInfos.size() <= offset) {
            qBoInfos = Lists.newArrayList();
        } else {
            if (qBoInfos.size() > offset + queryBoVo.getSize()) {
                qBoInfos = qBoInfos.subList(offset, offset + queryBoVo.getSize());
            } else {
                qBoInfos = qBoInfos.subList(offset, qBoInfos.size());
            }
        }

        QDataResponse<QPageInfo> response = new QDataResponse<>();
        response.setCode(QErrorCode.SUCCESS.getCode());

        QPageInfo pageInfo = new QPageInfo();
        pageInfo.setRows(qBoInfos);

        pageInfo.setTotal(entityClasss.size());
        response.setResult(pageInfo);
        return response;
    }

    /**
     * 获取对象信息
     *
     * @param boCode
     * @return
     */
    @GetMapping({"/bos/{boCode}"})
    public QDataResponse getBo(@PathVariable String boCode, @RequestParam(value = "profile", required = false) String profileInput) {
        if(!StringUtils.isEmpty(profileInput)) {
            this.contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, profileInput);
        }

        String profile = fetcher.getProfile(Collections.emptyMap());
        Optional<IEntityClass> optional = engine.loadByCode(boCode, profile);
        if (optional.isPresent()) {
            IEntityClass entityClass = optional.get();
            QBoResult boResult = new QBoResult();

            List<QBoApiVo> boApis = buildDefaultBoApis(entityClass.id());
            Map<String, Map> apis = Maps.newHashMap();
            boApis.stream().forEach(bApi -> {
                Map<String, String> mApi = Maps.newHashMap();
                mApi.put("url", bApi.getUrl());
                mApi.put("method", bApi.getMethod());
                apis.put(bApi.getCode(), mApi);
            });
            boResult.setApi(apis);

            EntityClassGroup describe = engine.describe(entityClass, fetcher.getProfile(Collections.emptyMap()));
            List<QBoFieldVo> collect = describe.getAllFields().stream()
                    .filter(field -> filterFields(field))
                    .map(this::convertField).collect(Collectors.toList());

//            List<QBoFieldVo> boFieldVos = entityClass.fields().stream()
//                    .filter(field -> filterFields(field))
//                    .map(this::convertField).collect(Collectors.toList());

//            List<QBoFieldVo> boFieldVos = metadataRepository.getBoDetailById(String.valueOf(entityClass.id())).getFields().stream()
//                    .filter(field -> !StringUtils.isEmpty(field.getName())).map(this::convertField2).collect(Collectors.toList());

//            if (entityClass.extendEntityClass() != null && entityClass.extendEntityClass().fields() != null) {
//                boFieldVos.addAll(
//                        entityClass.extendEntityClass().fields().stream()
//                                .filter(field -> filterFields(field))
//                                .map(this::convertField).collect(Collectors.toList())
////                        metadataRepository.getBoDetailById(String.valueOf(entityClass.extendEntityClass().id())).getFields().stream()
////                                .filter(field -> !StringUtils.isEmpty(field.getName())).map(this::convertField2).collect(Collectors.toList())
//                );
//            }

//            while (entityClass != null && entityClass.extendEntityClass() != null && entityClass.extendEntityClass().fields() != null) {
//                boFieldVos.addAll(
//                        entityClass.extendEntityClass().fields().stream()
//                                .filter(field -> filterFields(field))
//                                .map(this::convertField).collect(Collectors.toList())
////                        metadataRepository.getBoDetailById(String.valueOf(entityClass.extendEntityClass().id())).getFields().stream()
////                                .filter(field -> !StringUtils.isEmpty(field.getName())).map(this::convertField2).collect(Collectors.toList())
//                );
//                entityClass = engine.loadByCode(entityClass.extendEntityClass().code(), "").orElse(null);
//            }

            boResult.setFields(collect);
            return QDataResponse.ok(boResult);
        } else {
            return QDataResponse.fail("");
        }

    }

    /**
     * 获取应用代码
     *
     * @return
     */
    @GetMapping({"/appinfo"})
    public QDataResponse<QAppInfo> getAppInfo(@RequestParam(value = "profile", required = false) String profileInput) {
        if(!StringUtils.isEmpty(profileInput)) {
            this.contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, profileInput);
        }

        String profile = fetcher.getProfile(Collections.emptyMap());
        QAppInfo qAppInfo = new QAppInfo();

        Map<String, String> indexRouting = dynamicConfig.getIndexRouting();
        Map<String, String> masterRouting = dynamicConfig.getMasterRouting();
        Set<String> profiles = new HashSet<>();
        profiles.addAll(indexRouting.keySet());
        profiles.addAll(masterRouting.keySet());

        String appCode = engine.appCode();
        qAppInfo.setAppCode(appCode);
        qAppInfo.setProfiles(profiles);
        Optional<IEntityClass> auditBoEntityClassOptl = engine.loadByCode(AUDIT_BO_CODE, profile);
        if(auditBoEntityClassOptl.isPresent()) {
            qAppInfo.setAuditBoId(auditBoEntityClassOptl.get().id());
        } else {
            qAppInfo.setAuditBoId(null);
        }

        return QDataResponse.ok(qAppInfo);
    }

    List<QBoApiVo> buildDefaultBoApis(Long boId) {
        return defaultBoApis == null ? Lists.newArrayList() : defaultBoApis.stream().map(api -> {
            return new QBoApiVo(boId, api.getName(), api.getCode(), String.format(api.getUrl(), boId), api.getMethod());
        }).collect(Collectors.toList());
    }

    String convertType(String type) {
        type = StringUtils.lowerCase(type);
        if ("datetime".equals(type)) {
            type = "timestamp";
        } else if ("long".equals(type)) {
            type = "serialNo";
        }
        return type;
    }

    QBoFieldVo convertField(IEntityField field) {
        QBoFieldVo boFieldVo = new QBoFieldVo();
        boFieldVo.setCode(field.name());
        if (StringUtils.isEmpty(field.cnName())) {
            boFieldVo.setName(field.name());
        } else {
            boFieldVo.setName(field.cnName());
        }
        boFieldVo.setType(convertType(field.type().getType()));
        boFieldVo.setDefaultValue(field.defaultValue());
        boFieldVo.setEnumId(field.dictId());
        boFieldVo.setEnumCode(field.dictId());
        boFieldVo.setEditable(true);
        boFieldVo.setSearchable(field.config().isSearchable());
        boFieldVo.setRequired(field.config().isRequired());
        boFieldVo.setUnique(field.config().isIdentifie());
        boFieldVo.setValidateRule(field.config().getValidateRegexString());
        boFieldVo.setDecimalPoint(field.config().getPrecision());
        boFieldVo.setMaxLength(field.config().getMax());

        return boFieldVo;
    }

    QBoFieldVo convertField2(FieldItem field) {
        QBoFieldVo boFieldVo = new QBoFieldVo();
        boFieldVo.setCode(field.getCode());
        boFieldVo.setName(field.getName());
//        boFieldVo.setType(convertType(field.type().getType()));
        boFieldVo.setType(field.getType());
        boFieldVo.setDefaultValue(field.getDefaultValue());
        boFieldVo.setEnumId(field.getDictId());
        boFieldVo.setEnumCode(field.getEnumCode());
        boFieldVo.setEditable(true);
        boFieldVo.setSearchable(true);
        boFieldVo.setRequired("1".equals(field.getRequired()));
        boFieldVo.setUnique(false);
        boFieldVo.setValidateRule(null);
        boFieldVo.setDecimalPoint(StringUtils.isEmpty(field.getPrecision()) ? 0 : Integer.valueOf(field.getPrecision()));
        boFieldVo.setMaxLength(StringUtils.isEmpty(field.getMaxLength()) ? 0L : Long.valueOf(field.getMaxLength()));

        return boFieldVo;
    }

    String getRelationBoNames(String child, String parent) {
        if (!StringUtils.isEmpty(child) && !StringUtils.isEmpty(parent)) {
            return String.format("%s, 父：%s", child, parent);
        } else if (!StringUtils.isEmpty(child)) {
            return child;
        } else if (!StringUtils.isEmpty(parent)) {
            return String.format("父：%s", parent);
        } else {
            return "";
        }
    }

    boolean filterFields(IEntityField field) {
//        return !StringUtils.isEmpty(field.name()) && !field.name().contains(".id");
        return !StringUtils.isEmpty(field.name());
    }
}
