package com.xforceplus.ultraman.extensions.admin.om.service.impl;

import com.google.common.collect.Maps;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.extensions.admin.om.audit.OmAuditLog;
import com.xforceplus.ultraman.extensions.admin.om.service.OmAuditLogService;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.cmd.SingleCreateCmd;
import com.xforceplus.ultraman.sdk.core.service.EntityHandlerService;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import io.vavr.control.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.Map;
import java.util.Optional;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 12/4/2020 6:46 PM
 * @description:
 * @history:
 */
public class OmAuditLogServiceImpl implements OmAuditLogService {

    private Logger logger = LoggerFactory.getLogger(getClass());

    private final String AUDIT_BO_CODE = "oqsengineSdkOmAuditLog";

    private AuthConfig authConfig;

    @Autowired
    private EntityClassEngine entityService;

    @Autowired
    @Qualifier(value = "entityServiceHandler")
    private EntityHandlerService defaultEntityServiceHandler;

    @Autowired
    private ContextService contextService;

    public OmAuditLogServiceImpl(AuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    @Override
    public int saveUseSysBo(OmAuditLog auditLog) {
        Optional<IEntityClass> auditBoEntityClassOptl = entityService.loadByCode(AUDIT_BO_CODE, "");
        if (auditBoEntityClassOptl.isPresent()) {
            Map<String, Object> body = Maps.newHashMap();
            body.put("app_id", authConfig.getAppId());
            body.put("app_code", entityService.getCurrentApp() == null ? null : entityService.getCurrentApp().getAppCode());
            body.put("bo_id", auditLog.getBoId());
            body.put("bo_code", auditLog.getBoCode());
            body.put("bo_name", auditLog.getBoName());
            body.put("entity_id", auditLog.getEntityId());
            body.put("operate_type", auditLog.getOperateType());
            body.put("request_data", auditLog.getRequestData());
            body.put("response_data", auditLog.getResponseData());
            body.put("remark", auditLog.getRemark());
            body.put("operate_time", System.currentTimeMillis());
            body.put("operator_id", Optional.ofNullable(contextService.get(ContextKeys.LongKeys.ID)).orElse(0L));
            body.put("operator_code", Optional.ofNullable(contextService.get(ContextKeys.StringKeys.USERNAME)).orElse("system"));
            body.put("operator_name", Optional.ofNullable(contextService.get(ContextKeys.StringKeys.USER_DISPLAYNAME)).orElse("system"));
            body.put("tenant_id", Optional.ofNullable(contextService.get(ContextKeys.LongKeys.TENANT_ID)).orElse(0L));
            body.put("tenant_code", Optional.ofNullable(contextService.get(ContextKeys.StringKeys.TENANTCODE_KEY)).orElse("system"));
            Either<String, Long> result = defaultEntityServiceHandler.singleCreate(new SingleCreateCmd(String.valueOf(auditBoEntityClassOptl.get().id()), body, null));
            return Optional.ofNullable(result).orElseGet(() -> {
                return Either.left("没有返回值");
            }).map(x -> 1).getOrElseGet((x) -> 0);
        }
        return 0;
    }
}
