package com.xforceplus.ultraman.extensions.admin.om.controller;

import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.extensions.admin.om.audit.EnableOmAuditLog;
import com.xforceplus.ultraman.extensions.admin.om.util.OmTenantUtil;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Response;
import com.xforceplus.ultraman.metadata.domain.vo.dto.RowItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.SummaryItem;
import com.xforceplus.ultraman.sdk.core.cmd.*;
import com.xforceplus.ultraman.sdk.core.service.EntityHandlerService;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import static com.xforceplus.ultraman.sdk.controller.constants.Constants.FAILED;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 9/9/2020 4:56 PM
 * @description:
 * @history:
 */
@ResponseBody
@RequestMapping(value = {"api/0/${xplat.oqsengine.sdk.auth.appcode}/data-om","/data-om"})
public class QOmBoApiController {
    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    @Qualifier(value = "entityServiceHandler")
    private EntityHandlerService defaultEntityServiceHandler;
    @Autowired
    private OmTenantUtil omTenantUtil;

    @Autowired
    private ContextService contextService;

    private static final String MISSING_ENTITIES = "查询对象不存在";

    @GetMapping({"/bos/{boId}/entities/{id}"})
    @ResponseBody
    public ResponseEntity<Response<Map<String, Object>>> singleQuery(@PathVariable String boId, @PathVariable String id
            , @RequestParam(required = false, value = "v") String version
            , @RequestParam(required = false, value = "pageCode") String pageCode
            , @RequestParam(value = "profile", required = false) String profileInput) {

        if(!StringUtils.isEmpty(profileInput)) {
            this.contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, profileInput);
        }

        Either<String, Map<String, Object>> result = defaultEntityServiceHandler.singleQuery(new SingleQueryCmd(boId, id, version));
        return Optional.ofNullable(result).orElseGet(() -> {
            return Either.left("没有返回值");
        }).map((x) -> {
            Response<Map<String, Object>> rep = new Response();
            rep.setCode("1");
            rep.setMessage("获取成功");
            rep.setResult(x);
            return ResponseEntity.ok(rep);
        }).getOrElseGet((str) -> {
            Response<Map<String, Object>> rep = new Response();
            rep.setCode("-1");
            rep.setMessage(FAILED.concat(str));
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        });
    }

    @EnableOmAuditLog
    @DeleteMapping({"/bos/{boId}/entities/{id}"})
    @ResponseBody
    public ResponseEntity<Response<String>> singleDelete(@PathVariable String boId
            , @PathVariable String id, @RequestParam(required = false, value = "v") String version
            , @RequestParam(required = false, value = "pageCode") String pageCod
            , @RequestParam(value = "profile", required = false) String profileInput
    ) {
        if(!StringUtils.isEmpty(profileInput)) {
            this.contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, profileInput);
        }
        Either<String, Integer> result = defaultEntityServiceHandler.singleDelete(new SingleDeleteCmd(boId, id, version));
        return Optional.ofNullable(result).orElseGet(() -> {
            return Either.left("没有返回值");
        }).map((x) -> {
            Response<String> rep = new Response();
            rep.setCode("1");
            rep.setResult(String.valueOf(x));
            rep.setMessage("操作成功");
            return ResponseEntity.ok(rep);
        }).getOrElseGet((str) -> {
            Response<String> rep = new Response();
            rep.setCode("-1");
            rep.setMessage(FAILED.concat(str));
            rep.setResult(str);
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        });
    }

    @EnableOmAuditLog
    @PostMapping({"/bos/{boId}/entities"})
    @ResponseBody
    public ResponseEntity<Response<String>> singleCreate(@PathVariable String boId
            , @RequestParam(required = false, value = "v") String version
            , @RequestBody Map<String, Object> body
            , @RequestParam(value = "profile", required = false) String profileInput
    ) {
        if(!StringUtils.isEmpty(profileInput)) {
            this.contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, profileInput);
        }
        Either<String, Long> result = defaultEntityServiceHandler.singleCreate(new SingleCreateCmd(boId, body, version));
        return Optional.ofNullable(result).orElseGet(() -> {
            return Either.left("没有返回值");
        }).map((x) -> {
            Response<String> rep = new Response();
            rep.setCode("1");
            rep.setResult(String.valueOf(x));
            rep.setMessage("操作成功");
            return ResponseEntity.ok(rep);
        }).getOrElseGet((str) -> {
            Response<String> rep = new Response();
            rep.setCode("-1");
            rep.setMessage(FAILED.concat(str));
            rep.setResult(str);
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        });
    }

    @EnableOmAuditLog
    @PutMapping({"/bos/{boId}/entities/{id}"})
    @ResponseBody
    public ResponseEntity<Response<String>> singleModify(@PathVariable String boId
            , @PathVariable Long id, @RequestParam(required = false, value = "v") String version
            , @RequestBody Map<String, Object> body
            , @RequestParam(value = "profile", required = false) String profileInput
    ) {
        if(!StringUtils.isEmpty(profileInput)) {
            this.contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, profileInput);
        }
        Either<String, Integer> result = defaultEntityServiceHandler.singleUpdate(new SingleUpdateCmd(boId, id, body, version));
        return Optional.ofNullable(result).orElseGet(() -> {
            return Either.left("没有返回值");
        }).map((x) -> {
            Response<String> rep = new Response();
            rep.setCode("1");
            rep.setResult(String.valueOf(x));
            rep.setMessage("操作成功");
            return ResponseEntity.ok(rep);
        }).getOrElseGet((str) -> {
            Response<String> rep = new Response();
            rep.setCode("-1");
            rep.setMessage(FAILED.concat(str));
            rep.setResult(str);
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        });
    }

    @PostMapping({"/bos/{boId}/entities/query"})
    @ResponseBody
    public ResponseEntity<Response<RowItem<Map<String, Object>>>> conditionQuery(@PathVariable String boId
            , @RequestParam(required = false, value = "v") String version
            , @RequestBody ConditionQueryRequest condition
            , @RequestParam(required = false, value = "pageCode") String pageCode
            , @RequestParam(value = "profile", required = false) String profileInput
    ) {
//        if (condition.getConditions().getFields().size() == 1 && "sql".equals(condition.getConditions().getFields().get(0).getCode())) {
//            SqlQueryRequest sqlCondition = new SqlQueryRequest();
//            sqlCondition.setCondition(condition);
//            sqlCondition.setSql(condition.getConditions().getFields().get(0).getValue().get(0));
//            return sqlQuery(boId, null, sqlCondition);
//        }

        if(!StringUtils.isEmpty(profileInput)) {
            this.contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, profileInput);
        }
        //租户隔离
        omTenantUtil.buildTenantCondition(condition);

        Integer pageNo = condition.getPageNo() == null ? 1 : condition.getPageNo();
        Integer pageSize = condition.getPageSize() == null ? 20 : condition.getPageSize();
        if ((pageNo - 1) * pageSize >= 10000) {
            return extractRepList(Either.left("您查询的数据超过了1W条，请通过修改查询条件（如时间等）来缩小数据范围"));
        }

        Either<String, Tuple2<Integer, List<Map<String, Object>>>> result = defaultEntityServiceHandler
                .conditionSearch(new ConditionSearchCmd(boId, condition, version, pageCode));

        return this.extractRepList((Either) Optional.ofNullable(result).orElseGet(() -> {
            return Either.left("没有返回值");
        }));
    }

//    @PostMapping({"/bos/{boId}/entities/sql-query"})
//    @ResponseBody
//    public ResponseEntity<Response<RowItem<Map<String, Object>>>> sqlQuery(@PathVariable String boId
//            , @RequestParam(required = false, value = "v") String version, @RequestBody SqlQueryRequest sqlCondition) {
//        if (sqlCondition != null) {
//            ConditionQueryRequest condition = sqlCondition.getCondition();
//            //default
//            if (condition != null) {
//                if (condition.getPageNo() == null) {
//                    condition.setPageNo(1);
//                }
//
//                if (condition.getPageSize() == null) {
//                    condition.setPageSize(10);
//                }
//            }
//        }
//
//        Either<String, Tuple2<Integer, List<Map<String, Object>>>> result = conditionSearch(boId, sqlCondition, version);
//        return extractRepList(Optional.ofNullable(result).orElseGet(() -> Either.left("没有返回值")));
//    }

//    @PostMapping({"/bos/{boId}/entities/sql-trans"})
//    @ResponseBody
//    public String transql(@PathVariable String boId, @RequestBody Map sqlInfo) {
//        Optional<IEntityClass> entityClassOp = entityService.load(boId);
//
//        if (entityClassOp.isPresent()) {
//            return sqlInfo.containsKey("sql") && sqlInfo.get("sql") != null ?
//                    sqlQueryService.translateQuerySql(entityClassOp.get(), (String) sqlInfo.get("sql")) : "";
//        } else {
//            return "";
//        }
//    }

//    private Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(String boId, SqlQueryRequest sqlCondition, String version) {
//        Optional<IEntityClass> entityClassOp = Optional
//                .ofNullable(version).map(x -> entityService.load(boId, version)).orElseGet(() -> entityService.load(boId));
//
//        if (entityClassOp.isPresent()) {
//            return sqlQueryService.findRecordsBySql(entityClassOp.get(), sqlCondition);
//        } else {
//            return Either.left(MISSING_ENTITIES);
//        }
//    }

    private <T> ResponseEntity<Response<RowItem<T>>> extractRepList(Either<String, Tuple2<Integer, List<T>>> result) {
        Response rep = new Response();
        if (result.isRight()) {
            rep.setCode("1");
            Tuple2<Integer, List<T>> tuple = result.get();
            RowItem<T> rowItem = new RowItem<>();
            rowItem.setSummary(new SummaryItem(tuple._1()));
            rowItem.setRows(tuple._2());
            rep.setResult(rowItem);
            rep.setMessage("操作成功");
            return ResponseEntity.ok(rep);
        } else {
            rep.setCode("-1");
            rep.setMessage(FAILED.concat(result.getLeft()));
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        }
    }


}
