package com.xforceplus.ultraman.extensions.admin.om.controller;

import com.xforceplus.ultraman.sdk.controller.DictController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 9/9/2020 5:23 PM
 * @description:
 * @history:
 */
@ResponseBody
@RequestMapping(value = {"api/0/${xplat.oqsengine.sdk.auth.appcode}/data-om","/data-om"})
public class QOmDictApiController {

    @Autowired
    private DictController dictController;


    @GetMapping({"/enum/{id}/options"})
    @ResponseBody
    public ResponseEntity getDict(@PathVariable("id") String enumId, @RequestParam(required = false) String enumCode) {
        return dictController.getDict(enumId, enumCode);
    }

    @GetMapping({"/enums/options"})
    @ResponseBody
    public ResponseEntity getDicts(@RequestParam(required = false, value = "ids") String[] enumIds) {
        return dictController.getDicts(enumIds);
    }
}
