//package com.xforceplus.ultraman.extensions.admin.om.service.impl;
//
//import akka.grpc.javadsl.SingleResponseRequestBuilder;
//import com.google.common.collect.Lists;
//import com.xforceplus.tech.base.core.context.ContextService;
//import com.xforceplus.ultraman.extensions.admin.om.service.SqlQueryService;
//import com.xforceplus.ultraman.oqsengine.data.om.service.SqlQueryService;
//import com.xforceplus.ultraman.oqsengine.data.om.vo.SqlQueryRequest;
//import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
//import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
//import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
//import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
//import com.xforceplus.ultraman.oqsengine.sdk.EntityServiceClient;
//import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
//import com.xforceplus.ultraman.oqsengine.sdk.QueryFieldsUp;
//import com.xforceplus.ultraman.oqsengine.sdk.SelectBySql;
//import com.xforceplus.ultraman.oqsengine.sdk.service.HandleResultValueService;
//import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
//import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.EntityItem;
//import io.vavr.Tuple;
//import io.vavr.Tuple2;
//import io.vavr.control.Either;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.util.StringUtils;
//
//import java.util.Collections;
//import java.util.List;
//import java.util.Map;
//import java.util.Optional;
//import java.util.regex.Matcher;
//import java.util.regex.Pattern;
//import java.util.stream.Collectors;
//import java.util.stream.Stream;
//
//import static com.xforceplus.ultraman.oqsengine.pojo.converter.IEntityClassHelper.toEntityUp;
//
///**
// * @copyright： 上海云砺信息科技有限公司
// * @author: youyifan
// * @createTime: 10/16/2020 6:01 PM
// * @description:
// * @history:
// */
//public class SqlQueryServiceImpl implements SqlQueryService {
//
//    @Autowired
//    private HandleResultValueService handleResultValueService;
//
//    private final EntityServiceClient entityServiceClient;
//
//    private final ContextService contextService;
//
//    private final Pattern orderByRegex = Pattern.compile("order\\s+by", Pattern.CASE_INSENSITIVE);
//
//    private final Pattern storageNameRegex = Pattern.compile("jsonfields\\.[0-9]{19}[SL0-9]{1,2}", Pattern.CASE_INSENSITIVE);
//
//    public SqlQueryServiceImpl(EntityServiceClient entityServiceClient, ContextService contextService) {
//        this.entityServiceClient = entityServiceClient;
//        this.contextService = contextService;
//    }
//
//    /**
//     * Record has all field and not filtered;
//     * for export
//     *
//     * @param entityClass
//     * @param sqlCondition
//     * @return
//     */
//    @Override
//    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> findRecordsBySql(IEntityClass entityClass, SqlQueryRequest sqlCondition) {
//        return findRecords(entityClass, sqlCondition).map(tuple -> {
//
//            List<Map<String, Object>> mapResult = tuple._2().stream().map(record -> record.toMap(Optional.ofNullable(sqlCondition.getCondition())
//                    .map(ConditionQueryRequest::getStringKeys)
//                    .orElseGet(Collections::emptySet)))
//                    .collect(Collectors.toList());
//            return Tuple.of(tuple._1(), mapResult);
//        });
//    }
//
//    @Override
//    public String translateQuerySql(IEntityClass entityClass, String querySql) {
//        for (IEntityField field : entityClass.fields()) {
//            querySql = convertToCode(querySql, field);
//        }
//        return querySql;
//    }
//
//    Either<String, Tuple2<Integer, List<Record>>> findRecords(IEntityClass entityClass, SqlQueryRequest sqlCondition) {
////        String transId = contextService.get(TRANSACTION_KEY);
//
//        SingleResponseRequestBuilder<SelectBySql, OperationResult> requestBuilder = entityServiceClient.selectBySql();
//
//        /**
//         * condition
//         */
//        OperationResult result = requestBuilder.invoke(toSelectBySql(entityClass, sqlCondition))
//                .toCompletableFuture().join();
//
//        if (result.getCode() == OperationResult.Code.OK) {
//            List<Record> repList = result.getQueryResultList()
//                    .stream()
//                    .map(x -> handleResultValueService.toRecord(entityClass, x))
//                    .collect(Collectors.toList());
//            Tuple2<Integer, List<Record>> queryResult = Tuple.of(result.getTotalRow(), repList);
//            return Either.right(queryResult);
//        } else {
//            return Either.left(result.getMessage());
//        }
//    }
//
//    SelectBySql toSelectBySql(IEntityClass entityClass, SqlQueryRequest sqlCondition) {
//        SelectBySql.Builder select = SelectBySql
//                .newBuilder();
//
//        ConditionQueryRequest condition = sqlCondition.getCondition();
//
//        if (condition != null && condition.getPageNo() != null) {
//            select.setPageNo(condition.getPageNo());
//        }
//
//        if (condition != null && condition.getPageSize() != null) {
//            select.setPageSize(condition.getPageSize());
//        }
//
//        select.setEntity(toEntityUp(entityClass));
//
//        EntityItem entityItem = condition.getEntity();
//        if (entityItem != null) {
//            select.addAllQueryFields(toQueryFields(entityClass, entityItem));
//        }
//
//        if (!StringUtils.isEmpty(sqlCondition.getSql())) {
//            List<String> storageNames = findAllJsonFields(sqlCondition.getSql());
//
//            String whereSql = new StringBuffer(sqlCondition.getSql()).toString();
//
//            List<String> segmentSqls = Lists.newArrayList(storageNames);
//            Matcher result = orderByRegex.matcher(whereSql);
//            if (result.find()) {
//                String segmentSql = whereSql.substring(result.end());
//                for (int i = 0; i < storageNames.size(); i++) {
//                    String sn = storageNames.get(i);
//                    if (segmentSql.contains(sn)) {
//                        segmentSqls.remove(sn);
//                        segmentSqls.add(String.format("%s AS sort%s", sn, i));
//                        whereSql.replace(sn, "sort" + i);
//                    }
//                }
//            }
//
//            if (!StringUtils.isEmpty(whereSql)) {
//                select.setWhereSql("AND " + whereSql);
//            }
//
//            String selectSegmentSql = segmentSqls.stream().distinct().collect(Collectors.joining(","));
//            if (!StringUtils.isEmpty(selectSegmentSql)) {
//                select.setSelectSegmentSql(" ," + selectSegmentSql);
//            }
//
//        }
//
//        return select.build();
//    }
//
//    private static List<QueryFieldsUp> toQueryFields(IEntityClass entityClass, EntityItem entityItem) {
//
//        IEntityClassReader reader = new IEntityClassReader(entityClass);
//
//        /**
//         * only need to change query code name
//         */
//        Stream<String> fieldsUp = Optional.ofNullable(entityItem)
//                .map(EntityItem::getFields)
//                .orElseGet(Collections::emptyList).stream();
//
//
//        /**
//         * replace rel code with entityCode
//         */
//        Stream<String> fieldsUpFromRelatedEntities = Optional.ofNullable(entityItem)
//                .map(EntityItem::getEntities).orElseGet(Collections::emptyList)
//                .stream()
//                .flatMap(subEntityItem -> {
//                    return subEntityItem.getFields().stream().map(x -> subEntityItem.getCode() + "." + x);
//                });
//
//        return Stream.concat(fieldsUp, fieldsUpFromRelatedEntities)
//                .map(reader::column)
//                .filter(Optional::isPresent)
//                .map(Optional::get)
//                .map(column -> {
//                    return QueryFieldsUp
//                            .newBuilder()
//                            .setCode(column.name())
//                            .setId(column.id())
//                            .build();
//                })
//                .collect(Collectors.toList());
//    }
//
//    private String convertToCode(String whereSql, IEntityField field) {
//        Pattern storageNameRegex = getJsonFieldPattern(field);
//        Matcher result = storageNameRegex.matcher(whereSql);
//        return result.replaceAll(field.name());
//    }
//
//    private List<String> findAllJsonFields(String whereSql) {
//        Matcher result = storageNameRegex.matcher(whereSql);
//        List list = Lists.newArrayList();
//        while (result.find() && !list.contains(result.group())) {
//            list.add(result.group());
//        }
//        return list;
//    }
//
//    Pattern getJsonFieldPattern(IEntityField field) {
//        switch (field.type()) {
//            case STRING:
//            case ENUM:
//            case STRINGS:
//                return Pattern.compile(
//                        String.format("jsonfields\\.%s[S0-9]{1,2}", field.id()),
//                        Pattern.CASE_INSENSITIVE
//                );
//            case LONG:
//            case BOOLEAN:
//            case DATETIME:
//            case DECIMAL:
//                return Pattern.compile(
//                        String.format("jsonfields\\.%s[L0-9]{1,2}", field.id()),
//                        Pattern.CASE_INSENSITIVE
//                );
//            case UNKNOWN:
//            default:
//        }
//        return Pattern.compile(
//                String.format("jsonfields\\.%s[SL0-9]{1,2}", field.id()),
//                Pattern.CASE_INSENSITIVE
//        );
//    }
//}
