package com.xforceplus.ultraman.extensions.admin.om.util;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.domain.vo.dto.AppItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.domain.vo.dto.FieldCondition;
import com.xforceplus.ultraman.metadata.repository.MetadataRepository;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.util.Collection;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 11/22/2021 2:30 PM
 * @description:
 * @history:
 */
public class OmTenantUtil {
    private Logger logger = LoggerFactory.getLogger(getClass());

    private final String ULTRAMAN_ADMIN_ROLE = "ultramanAdmin";

    private final String APP_ADMIN_ROLE = "appAdmin";

    private final String ADMIN_ROLE_SUFFIX = "Admin";

    private final String DEVOPS_ROLE_SUFFIX = "DevOps";

    @Value("${xplat.meta.oqsengine.data.om.tenant.enabled:false}")
    private Boolean tenantEnabled;

    @Autowired
    private ContextService contextService;
    @Autowired
    private MetadataRepository metadataRepository;

    /**
     * 跳过租户隔离判断
     * @return
     */
    public boolean skipTenant(){
        String appAdminRoleCode = getAppRoleCode(ADMIN_ROLE_SUFFIX);
        String appDevOpsRoleCode = getAppRoleCode(DEVOPS_ROLE_SUFFIX);
        Collection<String> roleCodes =
                contextService.get(ContextKeys.CollectionKeys.ROLE_CODES);
        return roleCodes != null
                && (
                        roleCodes.contains(ULTRAMAN_ADMIN_ROLE)
                                || (roleCodes.contains(APP_ADMIN_ROLE) && roleCodes.contains(appAdminRoleCode))
                                || roleCodes.contains(appDevOpsRoleCode));
    }

    /**
     * 构建租户隔离条件
     * @param condition
     */
    public void buildTenantCondition(ConditionQueryRequest condition){
        if(tenantEnabled) {
            if(!skipTenant()) {
                if (!StringUtils.isEmpty(contextService.get(ContextKeys.StringKeys.TENANTID_KEY))) {
                    logger.debug("set query condition tenant_id = " + contextService.get(ContextKeys.StringKeys.TENANTID_KEY));
                    condition.getConditions()
                            .getFields()
                            .add(new FieldCondition("tenant_id", ConditionOp.eq, Lists.newArrayList(contextService.get(ContextKeys.StringKeys.TENANTID_KEY))));
                } else {
                    condition.getConditions()
                            .getFields()
                            .add(new FieldCondition("tenant_id", ConditionOp.eq, Lists.newArrayList("")));
                }
            }
        }
    }

    /**
     * 指定角色后缀获取相应具体应用角色
     * @param roleSuffix
     * @return
     */
    public String getAppRoleCode(String roleSuffix){
        AppItem appItem = metadataRepository.getCurrentApp();
        String code = StringUtils.isEmpty(appItem.getAppBranch()) ?
                appItem.getAppCode() : String.format("%s-%s", appItem.getAppCode(), appItem.getAppBranch());
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, code) + roleSuffix;
    }
}
