package com.xforceplus.ultraman.extensions.admin.om.configuration;

import com.xforceplus.ultraman.extensions.admin.om.controller.QOmBoApiController;
import com.xforceplus.ultraman.extensions.admin.om.controller.QOmBulkApiController;
import com.xforceplus.ultraman.extensions.admin.om.controller.QOmDataController;
import com.xforceplus.ultraman.extensions.admin.om.controller.QOmDictApiController;
import com.xforceplus.ultraman.extensions.admin.om.util.OmTenantUtil;
import com.xforceplus.ultraman.extensions.admin.web.OmController;
import com.xforceplus.ultraman.sdk.graphql.config.GraphQLAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfigureAfter(GraphQLAutoConfiguration.class)
@ConditionalOnProperty(value = "xplat.oqsengine.sdk.om.enabled", matchIfMissing = true)
public class OmAutoConfiguration {

    @Bean
    public OmTenantUtil omTenantUtil() {
        return new OmTenantUtil();
    }

    @Bean
    public OmController omController() {
        return new OmController();
    }

    @Bean
    public QOmBoApiController apiController() {
        return new QOmBoApiController();
    }

    @Bean
    public QOmDataController dataController(){
        return new QOmDataController();
    }
//
    @Bean
    public QOmBulkApiController bulkApiController(){
        return new QOmBulkApiController();
    }

    @Bean
    public QOmDictApiController qOmDictApiController() {
        return new QOmDictApiController();
    }

}
