package com.xforceplus.ultraman.extensions.admin.om.vo;

import com.xforceplus.ultraman.extensions.admin.om.enums.QErrorCode;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   youyifan
 * 创建时间: 7/28/2020 2:56 PM
 * 功能描述:
 * 修改历史:
 */
public class QDataResponse<T> {
    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = 1L;

    /**
     * 业务错误码
     */
    private long code;
    /**
     * 结果集
     */
    private T result;
    /**
     * 描述
     */
    private String message;

    public QDataResponse() {
        // to do nothing
    }

//    public PageResponse(IErrorCode errorCode) {
//        errorCode = Optional.ofNullable(errorCode).orElse(ApiErrorCode.FAILED);
//        this.code = errorCode.getCode();
//        this.message = errorCode.getMsg();
//    }

    public static <T> QDataResponse<T> ok(T result) {
        QErrorCode aec = QErrorCode.SUCCESS;
        if (result instanceof Boolean && Boolean.FALSE.equals(result)) {
            aec = QErrorCode.FAILED;
        }
        return restResult(result, aec);
    }

    public static <T> QDataResponse<T> fail(String msg) {
        return restResult(null, QErrorCode.FAILED.getCode(), msg);
    }

//    public static <T> PageResponse<T> failed(String message) {
//        return restResult(null, ApiErrorCode.FAILED.getCode(), message);
//    }
//
//    public static <T> PageResponse<T> failed(IErrorCode errorCode) {
//        return restResult(null, errorCode);
//    }

    public static <T> QDataResponse<T> restResult(T result, QErrorCode errorCode) {
        return restResult(result, errorCode.getCode(), errorCode.getMsg());
    }

    private static <T> QDataResponse<T> restResult(T result, long code, String msg) {
        QDataResponse<T> apiResult = new QDataResponse<>();
        apiResult.setCode(code);
        apiResult.setResult(result);
        apiResult.setMessage(msg);
        return apiResult;
    }

//    public boolean ok() {
//        return ApiErrorCode.SUCCESS.getCode() == code;
//    }
//
//    /**
//     * 服务间调用非业务正常，异常直接释放
//     */
//    public T serviceData() {
//        if (!ok()) {
//            throw new ApiException(this.message);
//        }
//        return result;
//    }


    public long getCode() {
        return code;
    }

    public void setCode(long code) {
        this.code = code;
    }

    public T getResult() {
        return result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
