/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.history.handler;

import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.common.iterator.DataIterator;
import com.xforceplus.ultraman.oqsengine.plus.history.dto.HistoryTaskInfo;
import com.xforceplus.ultraman.oqsengine.plus.history.dto.Status;
import com.xforceplus.ultraman.oqsengine.plus.history.handler.HistoryStorage;
import com.xforceplus.ultraman.oqsengine.plus.history.sql.HistoryTaskStorage;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MasterStorage;
import com.xforceplus.ultraman.sdk.infra.base.id.LongIdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.SnowflakeLongIdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.node.NodeIdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.node.TimeRandomNodeIdGenerator;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHistoryStorage
implements HistoryStorage {
    final Logger logger = LoggerFactory.getLogger(DefaultHistoryStorage.class);
    private static final int BATCH_QUERY_SIZE = 2048;
    private int querySize = 2048;
    @Resource
    private MasterStorage masterStorage;
    @Resource
    private EntityClassEngine engine;
    @Resource
    private HistoryTaskStorage historyTaskStorage;
    private ExecutorService asyncThreadPool;
    private LongIdGenerator idGenerator;

    public DefaultHistoryStorage(int querySize, ExecutorService executorService) {
        if (querySize > 0) {
            this.querySize = querySize;
        }
        this.asyncThreadPool = executorService;
        this.idGenerator = new SnowflakeLongIdGenerator((NodeIdGenerator)new TimeRandomNodeIdGenerator());
    }

    @Override
    public void doDocumentation(IEntityClass entityClass, HistoryTaskInfo historyTaskInfo) throws SQLException {
        this.logger.info("pending documentation task, batchId {}, taskId {}, entityClass {}, profile {}, start {}, end {}, op {}", new Object[]{historyTaskInfo.getBatchId(), historyTaskInfo.getTaskId(), entityClass.id(), entityClass.profile(), historyTaskInfo.getYear(), historyTaskInfo.getMonth(), HistoryTaskInfo.Op.DOCUMENTATION.name()});
        String table = entityClass.masterWriteTable(null != historyTaskInfo.getFilterProfile() && !historyTaskInfo.getFilterProfile().isEmpty());
        historyTaskInfo.setTableName(table);
        if (0 == this.historyTaskStorage.build(historyTaskInfo)) {
            historyTaskInfo.setMessage("TASK NOT START, TASK BUILDING FAILED.");
        }
        this.asyncThreadPool.submit(() -> this.handleDocumentationTask(historyTaskInfo, entityClass));
    }

    @Override
    public Collection<HistoryTaskInfo> doDeletes(Collection<Long> batchId, Long userId, String userName) throws SQLException {
        ArrayList<HistoryTaskInfo> deletes = new ArrayList<HistoryTaskInfo>();
        for (Long id : batchId) {
            Collection<HistoryTaskInfo> batches = this.historyTaskStorage.lists(id);
            for (HistoryTaskInfo historyTaskInfo : batches) {
                historyTaskInfo.setDeleteTime(System.currentTimeMillis());
                historyTaskInfo.setDeleteUserName(userName);
                historyTaskInfo.setDeleteUser(userId);
                if (historyTaskInfo.getStatus() != Status.FINISH_DOCUMENTATION.getCode()) {
                    this.logger.warn("task not finish documentation, can't not handle delete task");
                    throw new RuntimeException("task not finish documentation, can't not handle delete task");
                }
                Optional entityClassOp = this.engine.load(historyTaskInfo.getEntity() + "", historyTaskInfo.getProfile());
                if (!entityClassOp.isPresent()) {
                    historyTaskInfo.setMessage("DOCUMENTATIONS FAILED, ENTITY_CLASS NOT FOUND.");
                    this.historyTaskStorage.status(historyTaskInfo, Status.FINISH_DOCUMENTATION);
                    throw new RuntimeException("DOCUMENTATIONS FAILED, ENTITY_CLASS NOT FOUND.");
                }
                this.asyncThreadPool.submit(() -> this.handleDeleteTask(historyTaskInfo, (IEntityClass)entityClassOp.get()));
                deletes.add(historyTaskInfo);
            }
        }
        return deletes;
    }

    @Override
    public Collection<HistoryTaskInfo> list(long batchId) throws SQLException {
        return this.historyTaskStorage.lists(batchId);
    }

    @Override
    public Collection<HistoryTaskInfo> queryByTaskId(long taskId) throws SQLException {
        return this.historyTaskStorage.selectByTaskId(taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeleteTask(HistoryTaskInfo historyTaskInfo, IEntityClass entityClass) {
        DataIterator iterator = null;
        int staticStatus = historyTaskInfo.getStatus();
        try {
            iterator = this.masterStorage.iteratorIdHistory(entityClass, historyTaskInfo.getFilterProfile(), historyTaskInfo.historyTable(), historyTaskInfo.getRangeStart(), historyTaskInfo.getRangeEnd(), historyTaskInfo.getDeletePoint(), this.querySize);
            ArrayList<Long> ids = new ArrayList<Long>();
            int updateFlag = 0;
            int frequency = 10;
            historyTaskInfo.setStatus(Status.RUNNING_DELETE.getCode());
            historyTaskInfo.setMessage("DELETES RUN");
            this.historyTaskStorage.status(historyTaskInfo, Status.RUNNING_DELETE);
            boolean isCanceled = false;
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                ids.add(id);
                if (ids.size() != this.querySize) continue;
                int deleteSize = this.delete(ids, entityClass, historyTaskInfo.getRangeStart(), historyTaskInfo.getRangeEnd(), historyTaskInfo.getFilterProfile(), historyTaskInfo.getTableName());
                historyTaskInfo.setDeletePoint(id);
                historyTaskInfo.addDeletes(deleteSize);
                if (++updateFlag == frequency) {
                    if (0 == this.historyTaskStorage.update(historyTaskInfo)) {
                        isCanceled = true;
                        break;
                    }
                    updateFlag = 0;
                }
                ids.clear();
            }
            if (!isCanceled) {
                if (!ids.isEmpty()) {
                    int deleteSize = this.delete(ids, entityClass, historyTaskInfo.getRangeStart(), historyTaskInfo.getRangeEnd(), historyTaskInfo.getFilterProfile(), historyTaskInfo.getTableName());
                    historyTaskInfo.setDeletePoint((Long)ids.get(ids.size() - 1));
                    historyTaskInfo.addDeletes(deleteSize);
                }
                historyTaskInfo.setMessage("DELETES FINISH");
                this.historyTaskStorage.status(historyTaskInfo, Status.FINISH_DELETE);
            }
        }
        catch (Throwable t) {
            historyTaskInfo.setMessage(String.format("DELETES FAILED, MESSAGE : %s", t.getMessage()));
            try {
                this.historyTaskStorage.status(historyTaskInfo, Status.toBatchStatus(staticStatus));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (iterator != null) {
                try {
                    iterator.destroy();
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDocumentationTask(HistoryTaskInfo historyTaskInfo, IEntityClass entityClass) {
        DataIterator iterator = null;
        try {
            if (historyTaskInfo.getStatus() == Status.ERROR.getCode()) {
                return;
            }
            int updateFlag = 0;
            int frequency = 10;
            iterator = this.masterStorage.iteratorEntityHistory(entityClass, historyTaskInfo.getFilterProfile(), historyTaskInfo.getTableName(), historyTaskInfo.getRangeStart(), historyTaskInfo.getRangeEnd(), historyTaskInfo.getCheckPoint(), this.querySize);
            ArrayList<OqsEngineEntity> ids = new ArrayList<OqsEngineEntity>();
            boolean isCanceled = false;
            while (iterator.hasNext()) {
                OqsEngineEntity v = (OqsEngineEntity)iterator.next();
                ids.add(v);
                if (ids.size() != this.querySize) continue;
                this.documentation(ids, entityClass, historyTaskInfo.getFilterProfile(), historyTaskInfo.historyTable());
                historyTaskInfo.setCheckPoint(v.getId());
                historyTaskInfo.addTotal(ids.size());
                historyTaskInfo.addDocumentations(ids.size());
                historyTaskInfo.setMessage("DOCUMENTATIONS RUN");
                ids.clear();
                if (++updateFlag != frequency) continue;
                if (0 == this.historyTaskStorage.update(historyTaskInfo)) {
                    isCanceled = true;
                    break;
                }
                updateFlag = 0;
            }
            if (!isCanceled) {
                if (!ids.isEmpty()) {
                    this.documentation(ids, entityClass, historyTaskInfo.getFilterProfile(), historyTaskInfo.historyTable());
                    historyTaskInfo.addTotal(ids.size());
                    historyTaskInfo.addDocumentations(ids.size());
                }
                historyTaskInfo.setMessage("DOCUMENTATIONS FINISH");
                this.historyTaskStorage.status(historyTaskInfo, Status.FINISH_DOCUMENTATION);
            }
        }
        catch (Throwable t) {
            historyTaskInfo.setMessage("DOCUMENTATIONS ERROR :" + t.getMessage());
            try {
                this.historyTaskStorage.status(historyTaskInfo, Status.ERROR);
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        finally {
            if (iterator != null) {
                try {
                    iterator.destroy();
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public void documentation(List<OqsEngineEntity> oqsEngineEntities, IEntityClass entityClass, String filterProfile, String historyTable) {
        this.masterStorage.documentation(oqsEngineEntities, entityClass, filterProfile, historyTable);
    }

    public int delete(List<Long> ids, IEntityClass entityClass, long startTime, long endTime, String requestProfile, String table) {
        return this.masterStorage.batchDelete(ids, entityClass, startTime, endTime, requestProfile, table);
    }
}

