package com.xforceplus.ultraman.oqsengine.plus.history.dto;

import lombok.Data;

/**
 * Created by justin.xu on 12/2023.
 *
 * @since 1.8
 */
@Data
public class HistoryTaskInfo {
    public static final int UN_DONE_BATCH_SIZE = 0;
    private long id;
    private long batchId;
    private long taskId;
    private int part;
    private long entity;
    private String profile = "";
    private long rangeStart;
    private long rangeEnd;
    private int year;
    private int month;
    private int status;
    private long createTime;
    private long updateTime;
    private long deleteTime;
    private long total;
    private long documents;
    private long deletes;
    private long checkPoint;
    private long deletePoint;
    private String message = "";
    private int op;
    private long opUser;
    private String opUserName;
    private long deleteUser;
    private String deleteUserName;
    private String tableName;

    private String filterProfile = "";

    public String historyTable() {
        StringBuilder stringBuilder = new StringBuilder();

        stringBuilder.append(tableName).append("_").append(year).append("_").append(month);

        return stringBuilder.toString();
    }


    public void addTotal(int size) {
        total += size;
    }

    public void addDocumentations(int size) {
        documents += size;
    }

    public void addDeletes(int size) {
        deletes += size;
    }

    public enum Op {
        DOCUMENTATION,
        DELETE
    }



    public HistoryTaskInfo() {
    }

    public HistoryTaskInfo(long id, long batchId, long taskId, long entity, String profile, int op) {
        this.id = id;
        this.batchId = batchId;
        this.taskId = taskId;
        this.entity = entity;
        this.profile = profile;
        this.op = op;
    }
}
