package com.xforceplus.ultraman.oqsengine.plus.history.dto;

import com.xforceplus.ultraman.oqsengine.plus.common.dto.BatchStatus;

/**
 * Created by justin.xu on 12/2023.
 *
 * @since 1.8
 */
public enum Status {
    RUNNING_DOCUMENTATION(0),
    FINISH_DOCUMENTATION(1),
    RUNNING_DELETE(2),
    FINISH_DELETE(3),
    ERROR(4),
    CANCEL(5);

    private int code;

    Status(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    /**
     * 转换状态.
     *
     * @param code 状态字面量.
     * @return 实例.
     */
    public static Status toBatchStatus(int code) {
        for (Status batchStatus : Status.values()) {
            if (batchStatus.code == code) {
                return batchStatus;
            }
        }
        return null;
    }
}
