package com.xforceplus.ultraman.oqsengine.plus.history.sql;

import com.xforceplus.ultraman.oqsengine.plus.history.dto.HistoryTaskInfo;
import com.xforceplus.ultraman.oqsengine.plus.history.dto.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.sql.DataSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;


/**
 * 任务储存.
 *
 * @author xujia 2020/8/24
 * @since 1.8
 */
public class SQLHistoryTaskStorage implements HistoryTaskStorage {

    final Logger logger = LoggerFactory.getLogger(SQLHistoryTaskStorage.class);

    private DataSource devOpsDataSource;

    private String table = "history";

    public String getTable() {
        return table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public SQLHistoryTaskStorage(DataSource devOpsDataSource) {
        this.devOpsDataSource = devOpsDataSource;
    }

    @Override
    public Integer build(HistoryTaskInfo taskInfo) {
        try {
            Collection<HistoryTaskInfo> collection = selectActive(taskInfo.getEntity());
            //  每一次重建都会使之前已经开始的相同entityClassIds的任务取消.
            if (0 != collection.size()) {
                for (HistoryTaskInfo devOpsTaskInfo : collection) {
                    status(devOpsTaskInfo, Status.CANCEL);
                }
            }

            return new TaskStorageCommand(table).build(devOpsDataSource, taskInfo);
        } catch (Exception e) {
            logger.warn("init rebuild task failed, batchId : {}, taskId : {}, message : {}"
                    , taskInfo.getBatchId(), taskInfo.getTaskId(), e.getMessage());
            return 0;
        }
    }

    @Override
    public int update(HistoryTaskInfo taskInfo) throws SQLException {
        taskInfo.setUpdateTime(System.currentTimeMillis());
        return new TaskStorageCommand(table).update(devOpsDataSource, taskInfo);
    }

    @Override
    public int status(HistoryTaskInfo taskInfo, Status status) throws SQLException {
        taskInfo.setStatus(status.getCode());

        return new TaskStorageCommand(table).update(devOpsDataSource, taskInfo);
    }

    @Override
    @SuppressWarnings("unchecked")
    public Collection<HistoryTaskInfo> selectActive(long entityClassId) throws SQLException {
        return new TaskStorageCommand(table).selectActive(devOpsDataSource, entityClassId);
    }

    @Override
    @SuppressWarnings("unchecked")
    public Collection<HistoryTaskInfo> selectByTaskId(long taskId) throws SQLException {
        return new TaskStorageCommand(table).selectByTaskId(devOpsDataSource, taskId);
    }

    @Override
    @SuppressWarnings("unchecked")
    public Collection<HistoryTaskInfo> lists(long batchId) throws SQLException {
        return new TaskStorageCommand(table).lists(devOpsDataSource, batchId);
    }
}
