package com.xforceplus.ultraman.oqsengine.plus.history.sql;


import com.xforceplus.ultraman.oqsengine.plus.history.dto.HistoryTaskInfo;
import com.xforceplus.ultraman.oqsengine.plus.history.dto.Status;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;

/**
 * 任务储存.
 *
 * @author xujia 2020/8/24
 * @since 1.8
 */
public interface HistoryTaskStorage {

    /**
     * 生成buildTask.
     */
    Integer build(HistoryTaskInfo taskInfo) throws SQLException;

    /**
       任务信息更新.
     */
    int update(HistoryTaskInfo taskInfo) throws SQLException;

    /**
       任务完成.
     */
    int status(HistoryTaskInfo taskInfo, Status status) throws SQLException;

    /**
        当前活动任务.
     */
    Collection<HistoryTaskInfo> selectActive(long entityClassId) throws SQLException;

    /**
        获取taskId的任务.
     */
    public Collection<HistoryTaskInfo> selectByTaskId(long taskId) throws SQLException;


    /**
     * 列表查询.
     * @param batchId   批次id.
     * @return
     * @throws SQLException
     */
    public Collection<HistoryTaskInfo> lists(long batchId) throws SQLException;
}
