/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.history.sql;

import com.xforceplus.ultraman.oqsengine.plus.history.dto.HistoryTaskInfo;
import com.xforceplus.ultraman.oqsengine.plus.history.dto.Status;
import com.xforceplus.ultraman.oqsengine.plus.history.sql.HistoryTaskStorage;
import com.xforceplus.ultraman.oqsengine.plus.history.sql.TaskStorageCommand;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLHistoryTaskStorage
implements HistoryTaskStorage {
    final Logger logger = LoggerFactory.getLogger(SQLHistoryTaskStorage.class);
    private DataSource devOpsDataSource;
    private String table = "history";

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public SQLHistoryTaskStorage(DataSource devOpsDataSource) {
        this.devOpsDataSource = devOpsDataSource;
    }

    @Override
    public Integer build(HistoryTaskInfo taskInfo) {
        try {
            Collection<HistoryTaskInfo> collection = this.selectActive(taskInfo.getEntity());
            if (0 != collection.size()) {
                for (HistoryTaskInfo devOpsTaskInfo : collection) {
                    this.status(devOpsTaskInfo, Status.CANCEL);
                }
            }
            return new TaskStorageCommand(this.table).build(this.devOpsDataSource, taskInfo);
        }
        catch (Exception e) {
            this.logger.warn("init rebuild task failed, batchId : {}, taskId : {}, message : {}", new Object[]{taskInfo.getBatchId(), taskInfo.getTaskId(), e.getMessage()});
            return 0;
        }
    }

    @Override
    public int update(HistoryTaskInfo taskInfo) throws SQLException {
        taskInfo.setUpdateTime(System.currentTimeMillis());
        return new TaskStorageCommand(this.table).update(this.devOpsDataSource, taskInfo);
    }

    @Override
    public int status(HistoryTaskInfo taskInfo, Status status) throws SQLException {
        taskInfo.setStatus(status.getCode());
        return new TaskStorageCommand(this.table).update(this.devOpsDataSource, taskInfo);
    }

    @Override
    public Collection<HistoryTaskInfo> selectActive(long entityClassId) throws SQLException {
        return new TaskStorageCommand(this.table).selectActive(this.devOpsDataSource, entityClassId);
    }

    @Override
    public Collection<HistoryTaskInfo> selectByTaskId(long taskId) throws SQLException {
        return new TaskStorageCommand(this.table).selectByTaskId(this.devOpsDataSource, taskId);
    }

    @Override
    public Collection<HistoryTaskInfo> lists(long batchId) throws SQLException {
        return new TaskStorageCommand(this.table).lists(this.devOpsDataSource, batchId);
    }
}

