/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.infra.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.function.Function;

public class ReturnValueModifierProxy<T>
implements InvocationHandler {
    private final T target;
    private final Map<String, Function<Object, Object>> modifiers;

    public ReturnValueModifierProxy(T target, Map<String, Function<Object, Object>> modifiers) {
        this.target = target;
        this.modifiers = modifiers;
    }

    public static <T> T createProxy(T target, Map<String, Function<Object, Object>> modifiers, Class<?> ... interfaces) {
        return (T)Proxy.newProxyInstance(ReturnValueModifierProxy.class.getClassLoader(), interfaces, new ReturnValueModifierProxy<T>(target, modifiers));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = method.invoke(this.target, args);
        Function<Object, Object> modifier = this.modifiers.get(method.getName());
        if (modifier != null) {
            result = modifier.apply(result);
        }
        return result;
    }
}

