/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.infra.event.impl;

import com.xforceplus.ultraman.sdk.infra.Refreshable;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventEngineImpl
implements EventEngine {
    private static final Logger log = LoggerFactory.getLogger(EventEngineImpl.class);
    private Map<UltramanLifecycle, List<Refreshable>> mapping = new ConcurrentHashMap<UltramanLifecycle, List<Refreshable>>();

    @Override
    public void register(UltramanLifecycle lifecycle, Refreshable refreshable) {
        List list = this.mapping.getOrDefault((Object)lifecycle, new ArrayList());
        list.add(refreshable);
        this.mapping.put(lifecycle, list);
    }

    @Override
    public void trigger(UltramanLifecycle lifecycle, Object payload) {
        List<Refreshable> refreshables = this.mapping.get((Object)lifecycle);
        refreshables.forEach(x -> {
            try {
                x.onRefresh(x);
            }
            catch (Throwable throwable) {
                log.error("{}", throwable);
            }
        });
    }
}

